/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.util.json;

import com.conveyal.geojson.GeoJsonModule;
import com.conveyal.gtfs.util.json.JacksonSerializers;
import com.conveyal.gtfs.util.json.Rectangle2DDeserializer;
import com.conveyal.gtfs.util.json.Rectangle2DMixIn;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Map;

public class JsonManager<T> {
    private ObjectWriter ow;
    private ObjectMapper om;
    private Class<T> theClass;

    public JsonManager(Class<T> theClass) {
        this.theClass = theClass;
        this.om = new ObjectMapper();
        this.om.addMixInAnnotations(Rectangle2D.class, Rectangle2DMixIn.class);
        this.om.registerModule((Module)new GeoJsonModule());
        SimpleModule deser = new SimpleModule();
        deser.addDeserializer(LocalDate.class, (JsonDeserializer)new JacksonSerializers.LocalDateStringDeserializer());
        deser.addSerializer(LocalDate.class, (JsonSerializer)new JacksonSerializers.LocalDateStringSerializer());
        deser.addDeserializer(Rectangle2D.class, (JsonDeserializer)new Rectangle2DDeserializer());
        this.om.registerModule((Module)deser);
        this.om.getSerializerProvider().setNullKeySerializer((JsonSerializer)new JacksonSerializers.MyDtoNullKeySerializer());
        SimpleFilterProvider filters = new SimpleFilterProvider();
        filters.addFilter("bbox", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"west", "east", "south", "north"}));
        this.ow = this.om.writer((FilterProvider)filters);
    }

    public void addMixin(Class target, Class mixin) {
        this.om.addMixInAnnotations(target, mixin);
    }

    public String write(Object o) throws JsonProcessingException {
        if (o instanceof String) {
            return (String)o;
        }
        return this.ow.writeValueAsString(o);
    }

    public String write(Collection<T> c) throws JsonProcessingException {
        return this.ow.writeValueAsString(c);
    }

    public String write(Map<String, T> map) throws JsonProcessingException {
        return this.ow.writeValueAsString(map);
    }

    public T read(String s) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.om.readValue(s, this.theClass);
    }

    public T read(JsonParser p) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.om.readValue(p, this.theClass);
    }

    public T read(JsonNode asJson) {
        return (T)this.om.convertValue((Object)asJson, this.theClass);
    }
}

