/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.validator;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.DuplicateStopError;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.validator.GTFSValidator;
import com.conveyal.gtfs.validator.model.DuplicateStops;
import com.conveyal.gtfs.validator.service.GeoUtils;
import com.conveyal.gtfs.validator.service.ProjectedCoordinate;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class DuplicateStopsValidator
extends GTFSValidator {
    static GeometryFactory geometryFactory = new GeometryFactory();
    private static Double buffer = 2.0;

    public boolean validate(GTFSFeed feed, boolean repair, Double bufferDistance) {
        if (bufferDistance != null) {
            buffer = bufferDistance;
        }
        return this.validate(feed, repair);
    }

    @Override
    public boolean validate(GTFSFeed feed, boolean repair) {
        boolean isValid = true;
        Collection<Stop> stops = feed.stops.values();
        STRtree stopIndex = feed.getSpatialIndex();
        HashMap<String, Point> stopProjectedGeomMap = new HashMap<String, Point>();
        for (Stop stop : stops) {
            Coordinate stopCoord = new Coordinate(stop.stop_lat, stop.stop_lon);
            ProjectedCoordinate projectedStopCoord = null;
            try {
                projectedStopCoord = GeoUtils.convertLatLonToEuclidean(stopCoord);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            Point geom = geometryFactory.createPoint((Coordinate)projectedStopCoord);
            stopProjectedGeomMap.put(stop.stop_id, geom);
        }
        ArrayList<DuplicateStops> duplicateStops = new ArrayList<DuplicateStops>();
        if (stopIndex != null) {
            for (Geometry stopGeom : stopProjectedGeomMap.values()) {
                Geometry bufferedStopGeom = stopGeom.buffer(buffer.doubleValue());
                List stopCandidates = stopIndex.query(bufferedStopGeom.getEnvelopeInternal());
                if (stopCandidates.size() <= 1) continue;
                for (Stop stop1 : stopCandidates) {
                    for (Stop stop2 : stopCandidates) {
                        Geometry stop2Geom;
                        Geometry stop1Geom;
                        double distance;
                        if (stop1.stop_id == stop2.stop_id) continue;
                        Boolean stopPairAlreadyFound = false;
                        for (DuplicateStops duplicate : duplicateStops) {
                            if ((!duplicate.stop1.feed_id.equals(stop1.feed_id) || !duplicate.stop2.feed_id.equals(stop2.feed_id)) && (!duplicate.stop2.feed_id.equals(stop1.feed_id) || !duplicate.stop1.feed_id.equals(stop2.feed_id))) continue;
                            stopPairAlreadyFound = true;
                        }
                        if (stopPairAlreadyFound.booleanValue() || !((distance = (stop1Geom = (Geometry)stopProjectedGeomMap.get(stop1.stop_id)).distance(stop2Geom = (Geometry)stopProjectedGeomMap.get(stop2.stop_id))) <= buffer)) continue;
                        DuplicateStops duplicateStop = new DuplicateStops(stop1, stop2, distance);
                        duplicateStops.add(duplicateStop);
                        isValid = false;
                        feed.errors.add(new DuplicateStopError(duplicateStop));
                    }
                }
            }
        }
        return isValid;
    }
}

