/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.validator;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.MisplacedStopError;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.validator.GTFSValidator;
import com.conveyal.gtfs.validator.service.GeoUtils;
import com.conveyal.gtfs.validator.service.ProjectedCoordinate;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.strtree.STRtree;

public class MisplacedStopValidator
extends GTFSValidator {
    @Override
    public boolean validate(GTFSFeed feed, boolean repair) {
        boolean isValid = true;
        Envelope nullIsland = new Envelope(-1.0, 1.0, -1.0, 1.0);
        STRtree spatialIndex = feed.getSpatialIndex();
        GeometryFactory geometryFactory = new GeometryFactory();
        long index = 1L;
        for (Stop stop : feed.stops.values()) {
            try {
                Coordinate stopCoord = new Coordinate(stop.stop_lon, stop.stop_lat);
                if (nullIsland.contains(stopCoord)) {
                    feed.errors.add(new MisplacedStopError(stop.stop_id, index, stop));
                    isValid = false;
                    continue;
                }
                ProjectedCoordinate projectedStopCoord = null;
                try {
                    projectedStopCoord = GeoUtils.convertLatLonToEuclidean(stopCoord);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
                Double bufferDistance = 1.0;
                Point geom = geometryFactory.createPoint((Coordinate)projectedStopCoord);
                Geometry bufferedStopGeom = geom.buffer(bufferDistance.doubleValue());
            }
            catch (Exception e) {
                continue;
            }
            ++index;
        }
        return isValid;
    }
}

