/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.validator;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.OverlappingTripsInBlockError;
import com.conveyal.gtfs.model.CalendarDate;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.validator.GTFSValidator;
import com.google.common.collect.Iterables;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class OverlappingTripsValidator
extends GTFSValidator {
    private static Double distanceMultiplier = 1.0;

    public boolean validate(GTFSFeed feed, boolean repair, Double distanceMultiplier) {
        OverlappingTripsValidator.distanceMultiplier = distanceMultiplier;
        return this.validate(feed, repair);
    }

    @Override
    public boolean validate(GTFSFeed feed, boolean repair) {
        HashMap blockIntervals = new HashMap();
        feed.trips.values().stream().iterator().forEachRemaining(trip -> {
            if (trip.block_id != null) {
                Iterable<StopTime> stopTimes = feed.getOrderedStopTimesForTrip(trip.trip_id);
                BlockInterval blockInterval = new BlockInterval();
                blockInterval.trip = trip;
                StopTime firstStopTime = (StopTime)Iterables.get(stopTimes, (int)0);
                blockInterval.startTime = firstStopTime.departure_time;
                blockInterval.firstStop = firstStopTime;
                blockInterval.lastStop = (StopTime)Iterables.getLast(stopTimes);
                if (!blockIntervals.containsKey(trip.block_id)) {
                    blockIntervals.put(trip.block_id, new ArrayList());
                }
                ((ArrayList)blockIntervals.get(trip.block_id)).add(blockInterval);
            }
        });
        for (String blockId : blockIntervals.keySet()) {
            ArrayList intervals = (ArrayList)blockIntervals.get(blockId);
            Collections.sort(intervals, new BlockIntervalComparator());
            int iOffset = 0;
            for (BlockInterval i1 : intervals) {
                block6: for (BlockInterval i2 : intervals.subList(iOffset, intervals.size() - 1)) {
                    String tripId1 = i1.trip.trip_id;
                    String tripId2 = i2.trip.trip_id;
                    if (tripId1.equals(tripId2) || i1.lastStop.departure_time <= i2.firstStop.arrival_time || i2.lastStop.departure_time <= i1.firstStop.arrival_time) continue;
                    if (i1.trip.service_id.equals(i2.trip.service_id)) {
                        String[] tripIds = new String[]{tripId1, tripId2};
                        try {
                            feed.errors.add(new OverlappingTripsInBlockError(0L, "block_id", blockId, i1.trip.route_id, tripIds));
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    Service s1 = (Service)feed.services.get((Object)i1.trip.service_id);
                    Service s2 = (Service)feed.services.get((Object)i2.trip.service_id);
                    boolean overlap = Service.checkOverlap(s1, s2);
                    for (Map.Entry<LocalDate, CalendarDate> d1 : s1.calendar_dates.entrySet()) {
                        boolean activeOnDate;
                        LocalDate date = d1.getKey();
                        boolean bl = activeOnDate = s1.activeOn(date) && s2.activeOn(date);
                        if (!activeOnDate && !overlap) continue;
                        String[] tripIds = new String[]{tripId1, tripId2};
                        try {
                            feed.errors.add(new OverlappingTripsInBlockError(0L, "block_id", blockId, i1.trip.route_id, tripIds));
                        }
                        catch (Exception e) {}
                        continue block6;
                    }
                }
            }
        }
        return false;
    }

    private class BlockIntervalComparator
    implements Comparator<BlockInterval> {
        private BlockIntervalComparator() {
        }

        @Override
        public int compare(BlockInterval a, BlockInterval b) {
            return new Integer(a.startTime).compareTo(new Integer(b.startTime));
        }
    }

    private class BlockInterval
    implements Comparable<BlockInterval> {
        Trip trip;
        Integer startTime;
        StopTime firstStop;
        StopTime lastStop;

        private BlockInterval() {
        }

        @Override
        public int compareTo(BlockInterval o) {
            return new Integer(this.firstStop.arrival_time).compareTo(new Integer(o.firstStop.arrival_time));
        }
    }
}

