/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.validator;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.MissingShapeError;
import com.conveyal.gtfs.error.ReversedTripShapeError;
import com.conveyal.gtfs.error.ShapeMissingCoordinatesError;
import com.conveyal.gtfs.model.ShapePoint;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.validator.GTFSValidator;
import com.conveyal.gtfs.validator.service.GeoUtils;
import com.google.common.collect.Iterables;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapdb.Fun;

public class ReversedTripsValidator
extends GTFSValidator {
    private static Double distanceMultiplier = 1.0;
    static GeometryFactory geometryFactory = new GeometryFactory();

    public boolean validate(GTFSFeed feed, boolean repair, Double distanceMultiplier) {
        ReversedTripsValidator.distanceMultiplier = distanceMultiplier;
        return this.validate(feed, repair);
    }

    @Override
    public boolean validate(GTFSFeed feed, boolean repair) {
        boolean isValid = true;
        int errorLimit = 5000;
        int missingShapeErrorCount = 0;
        int missingCoordinatesErrorCount = 0;
        int reversedTripShapeErrorCount = 0;
        Collection trips = feed.trips.values();
        HashMap missingShapesMap = new HashMap();
        for (Trip trip : trips) {
            Point lastShapeGeom;
            Point firstShapeGeom;
            Point lastStopGeom;
            Point firstStopGeom;
            String tripId = trip.trip_id;
            if (trip.shape_id == null) {
                isValid = false;
                if (missingShapeErrorCount < errorLimit) {
                    feed.errors.add(new MissingShapeError(trip));
                }
                ++missingShapeErrorCount;
                continue;
            }
            String shapeId = trip.shape_id;
            Iterable<StopTime> stopTimes = feed.getOrderedStopTimesForTrip(tripId);
            StopTime firstStop = (StopTime)Iterables.get(stopTimes, (int)0);
            StopTime lastStop = (StopTime)Iterables.getLast(stopTimes);
            ShapePoint firstShape = (ShapePoint)feed.shape_points.ceilingEntry((Fun.Tuple2<String, Integer>)Fun.t2((Object)shapeId, null)).getValue();
            Map.Entry entry = feed.shape_points.floorEntry((Fun.Tuple2<String, Integer>)new Fun.Tuple2((Object)shapeId, Fun.HI));
            ShapePoint lastShape = (ShapePoint)entry.getValue();
            try {
                Coordinate firstStopCoord = new Coordinate(feed.stops.get((Object)firstStop.stop_id).stop_lat, feed.stops.get((Object)firstStop.stop_id).stop_lon);
                Coordinate lastStopCoord = new Coordinate(feed.stops.get((Object)lastStop.stop_id).stop_lat, feed.stops.get((Object)lastStop.stop_id).stop_lon);
                firstStopGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(firstStopCoord));
                lastStopGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(lastStopCoord));
                Coordinate firstShapeCoord = new Coordinate(firstShape.shape_pt_lat, firstShape.shape_pt_lon);
                Coordinate lastShapeCoord = new Coordinate(lastShape.shape_pt_lat, lastShape.shape_pt_lon);
                firstShapeGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(firstShapeCoord));
                lastShapeGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(lastShapeCoord));
            }
            catch (Exception any) {
                isValid = false;
                List listOfTrips = missingShapesMap.containsKey(firstShape) ? (List)missingShapesMap.get(firstShape) : new ArrayList();
                listOfTrips.add(tripId);
                missingShapesMap.put(firstShape, listOfTrips);
                ++missingCoordinatesErrorCount;
                continue;
            }
            Double distanceFirstStopToStart = firstStopGeom.distance((Geometry)firstShapeGeom);
            Double distanceFirstStopToEnd = firstStopGeom.distance((Geometry)lastShapeGeom);
            Double distanceLastStopToEnd = lastStopGeom.distance((Geometry)lastShapeGeom);
            Double distanceLastStopToStart = lastStopGeom.distance((Geometry)firstShapeGeom);
            if (!(distanceFirstStopToStart > distanceFirstStopToEnd * distanceMultiplier) || !(distanceLastStopToEnd > distanceLastStopToStart * distanceMultiplier)) continue;
            if (reversedTripShapeErrorCount < errorLimit) {
                feed.errors.add(new ReversedTripShapeError(trip));
            }
            ++reversedTripShapeErrorCount;
            isValid = false;
        }
        if (missingCoordinatesErrorCount > 0) {
            for (Map.Entry entry : missingShapesMap.entrySet()) {
                String[] tripIdList = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
                feed.errors.add(new ShapeMissingCoordinatesError((ShapePoint)entry.getKey(), tripIdList));
            }
        }
        return isValid;
    }
}

