/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.validator;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.DuplicateTripError;
import com.conveyal.gtfs.error.NoStopTimesForTripError;
import com.conveyal.gtfs.error.StopTimeDepartureBeforeArrivalError;
import com.conveyal.gtfs.error.StopTimesOutOfSequenceError;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.validator.GTFSValidator;
import com.google.common.collect.Iterables;
import java.time.LocalTime;
import java.util.HashMap;

public class TripTimesValidator
extends GTFSValidator {
    @Override
    public boolean validate(GTFSFeed feed, boolean repair) {
        boolean isValid = true;
        int errorLimit = 2000;
        int noStopTimesErrorCount = 0;
        int stopTimeDepartureBeforeArrivalErrorCount = 0;
        int stopTimesOutOfSequenceErrorCount = 0;
        int duplicateTripErrorCount = 0;
        HashMap<String, String> duplicateTripHash = new HashMap<String, String>();
        for (Trip trip : feed.trips.values()) {
            String tripId = trip.trip_id;
            Iterable<StopTime> stopTimes = feed.getOrderedStopTimesForTrip(tripId);
            if (stopTimes == null || Iterables.size(stopTimes) == 0) {
                if (noStopTimesErrorCount < errorLimit) {
                    feed.errors.add(new NoStopTimesForTripError(trip));
                }
                isValid = false;
                ++noStopTimesErrorCount;
                continue;
            }
            StopTime previousStopTime = null;
            for (StopTime stopTime : stopTimes) {
                if (stopTime.departure_time < stopTime.arrival_time) {
                    if (stopTimeDepartureBeforeArrivalErrorCount < errorLimit) {
                        feed.errors.add(new StopTimeDepartureBeforeArrivalError(stopTime));
                    }
                    ++stopTimeDepartureBeforeArrivalErrorCount;
                    isValid = false;
                }
                if (stopTime.arrival_time == Integer.MIN_VALUE) continue;
                if (previousStopTime != null && stopTime.arrival_time < previousStopTime.departure_time) {
                    if (stopTimesOutOfSequenceErrorCount < errorLimit) {
                        feed.errors.add(new StopTimesOutOfSequenceError(stopTime, previousStopTime));
                    }
                    ++stopTimesOutOfSequenceErrorCount;
                    isValid = false;
                    break;
                }
                previousStopTime = stopTime;
                if (repair || stopTimesOutOfSequenceErrorCount < errorLimit) continue;
                break;
            }
            String blockId = "";
            if (trip.block_id != null) {
                blockId = trip.block_id;
            }
            String patternId = feed.tripPatternMap.get(tripId);
            String patternName = feed.patterns.get((Object)patternId).name;
            int firstDeparture = ((StopTime)Iterables.get(stopTimes, (int)0)).departure_time;
            int lastArrival = ((StopTime)Iterables.getLast(stopTimes)).arrival_time;
            String tripKey = trip.service_id + "_" + blockId + "_" + firstDeparture + "_" + lastArrival + "_" + patternId;
            if (duplicateTripHash.containsKey(tripKey)) {
                String firstDepartureString = LocalTime.ofSecondOfDay(((StopTime)Iterables.get(stopTimes, (int)0)).departure_time % 86399).toString();
                String lastArrivalString = LocalTime.ofSecondOfDay(((StopTime)Iterables.getLast(stopTimes)).arrival_time % 86399).toString();
                String duplicateTripId = (String)duplicateTripHash.get(tripKey);
                Trip duplicateTrip = (Trip)feed.trips.get((Object)duplicateTripId);
                long line = trip.sourceFileLine > duplicateTrip.sourceFileLine ? trip.sourceFileLine : duplicateTrip.sourceFileLine;
                feed.errors.add(new DuplicateTripError(trip, line, duplicateTripId, patternName, firstDepartureString, lastArrivalString));
                isValid = false;
            } else {
                duplicateTripHash.put(tripKey, tripId);
            }
            if (repair || duplicateTripErrorCount < errorLimit) continue;
            break;
        }
        return isValid;
    }
}

