/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.validator;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.UnusedStopError;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.validator.GTFSValidator;
import java.util.Iterator;

public class UnusedStopValidator
extends GTFSValidator {
    @Override
    public boolean validate(GTFSFeed feed, boolean repair) {
        boolean isValid = true;
        long index = 1L;
        int unusedStopErrorCount = 0;
        int errorLimit = 2000;
        Iterator<Stop> iter = feed.stops.values().iterator();
        while (iter.hasNext()) {
            Stop stop = iter.next();
            if (!feed.stopCountByStopTime.containsKey(stop.stop_id)) {
                if (unusedStopErrorCount < errorLimit) {
                    feed.errors.add(new UnusedStopError(stop));
                    ++unusedStopErrorCount;
                }
                isValid = false;
                if (repair) {
                    iter.remove();
                }
            }
            ++index;
            if (repair || unusedStopErrorCount < errorLimit) continue;
            break;
        }
        return isValid;
    }
}

