/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.object_differ;

import com.conveyal.object_differ.KeyExtractor;
import com.conveyal.object_differ.MapComparisonWrapper;
import com.conveyal.object_differ.MultimapWrapper;
import com.conveyal.object_differ.StandardMapWrapper;
import com.conveyal.object_differ.TIntIntMapWrapper;
import com.conveyal.object_differ.TIntObjectMapWrapper;
import com.conveyal.object_differ.TLongObjectMapWrapper;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDiffer {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectDiffer.class);
    private static final int MAX_RECURSION_DEPTH = 300;
    private int depth = 0;
    private Stack<Object> breadcrumbs = new Stack();
    private int maxDepthReached = 0;
    Set<Object> alreadySeen = Sets.newIdentityHashSet();
    private Set<String> ignoreFields = new HashSet<String>();
    private Set<Class> ignoreClasses = new HashSet<Class>();
    private Set<Class> useEquals = new HashSet<Class>();
    private Map<String, KeyExtractor> keyExtractors = new HashMap<String, KeyExtractor>();
    private int nDifferences = 0;
    private int nObjectsCompared = 0;
    private boolean compareIdenticalObjects = false;
    private boolean skipTransientFields = false;

    public void enableComparingIdenticalObjects() {
        this.compareIdenticalObjects = true;
    }

    public void skipTransientFields() {
        this.skipTransientFields = true;
    }

    public void ignoreFields(String ... fields) {
        this.ignoreFields.addAll(Arrays.asList(fields));
    }

    public void ignoreClasses(Class ... classes) {
        this.ignoreClasses.addAll(Arrays.asList(classes));
    }

    public void useEquals(Class ... classes) {
        this.useEquals.addAll(Arrays.asList(classes));
    }

    public <T> void setKeyExtractor(String fieldName, KeyExtractor<T, ?> keyExtractor) {
        this.keyExtractors.put(fieldName, keyExtractor);
    }

    public void compareTwoObjects(Object a, Object b) {
        ++this.nObjectsCompared;
        if (this.compareIdenticalObjects ? a == null && b == null : a == b) {
            return;
        }
        if (a != null && b == null || a == null && b != null) {
            this.difference("One reference was null but not the other.", new Object[0]);
            return;
        }
        Class<?> classToCompare = a.getClass();
        if (b.getClass() != classToCompare) {
            this.difference("Classes are not the same: %s vs %s", classToCompare.getSimpleName(), b.getClass().getSimpleName());
            return;
        }
        if (this.ignoreClasses.contains(classToCompare)) {
            return;
        }
        if (this.isPrimitive(a) || this.useEquals.contains(a.getClass())) {
            if (!a.equals(b)) {
                this.difference("Primitive %s value mismatch: %s vs %s", classToCompare.getSimpleName(), a.toString(), b.toString());
            }
            return;
        }
        if (this.alreadySeen.contains(a)) {
            return;
        }
        this.alreadySeen.add(a);
        ++this.depth;
        this.breadcrumbs.push(classToCompare);
        if (this.depth > 300) {
            this.difference("Max recursion depth exceeded.", new Object[0]);
            throw new RuntimeException("Max recursion depth exceeded: 300");
        }
        if (this.depth > this.maxDepthReached) {
            this.maxDepthReached = this.depth;
        }
        if (a instanceof Map) {
            this.compareMaps(new StandardMapWrapper((Map)a), new StandardMapWrapper((Map)b));
        } else if (a instanceof TIntIntMap) {
            this.compareMaps(new TIntIntMapWrapper((TIntIntMap)a), new TIntIntMapWrapper((TIntIntMap)b));
        } else if (a instanceof TIntObjectMap) {
            this.compareMaps(new TIntObjectMapWrapper((TIntObjectMap)a), new TIntObjectMapWrapper((TIntObjectMap)b));
        } else if (a instanceof TLongObjectMap) {
            this.compareMaps(new TLongObjectMapWrapper((TLongObjectMap)a), new TLongObjectMapWrapper((TLongObjectMap)b));
        } else if (a instanceof Multimap) {
            this.compareMaps(new MultimapWrapper((Multimap)a), new MultimapWrapper((Multimap)b));
        } else if (a instanceof TIntArrayList) {
            this.compareCollections(Ints.asList((int[])((TIntArrayList)a).toArray()), Ints.asList((int[])((TIntArrayList)b).toArray()));
        } else if (a instanceof Collection) {
            this.compareCollections((Collection)a, (Collection)b);
        } else if (classToCompare.isArray()) {
            this.compareArrays(a, b);
        } else {
            this.compareFieldByField(a, b);
        }
        --this.depth;
        this.breadcrumbs.pop();
    }

    private void compareFieldByField(Object a, Object b) {
        Class<?> classToCompare = a.getClass();
        List<Field> fieldsToCompare = this.getAllFields(classToCompare);
        for (Field field : fieldsToCompare) {
            this.breadcrumbs.push(field);
            try {
                field.setAccessible(true);
                Object valueA = field.get(a);
                Object valueB = field.get(b);
                KeyExtractor keyExtractor = this.keyExtractors.get(field.getName());
                if (keyExtractor != null) {
                    valueA = this.extractKeys(valueA, keyExtractor);
                    valueB = this.extractKeys(valueB, keyExtractor);
                }
                this.compareTwoObjects(valueA, valueB);
            }
            catch (IllegalAccessException | IllegalArgumentException | InaccessibleObjectException e) {
                throw new RuntimeException(e);
            }
            this.breadcrumbs.pop();
        }
    }

    private boolean isPrimitive(Object value) {
        return value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Character;
    }

    private void compareMaps(MapComparisonWrapper a, MapComparisonWrapper b) {
        Object missingEntryB;
        if (a.size() != b.size()) {
            this.difference("Maps differ in size: %d vs %d", a.size(), b.size());
            return;
        }
        for (Object aKey : a.allKeys()) {
            this.breadcrumbs.push(aKey);
            if (b.containsKey(aKey)) {
                Object aValue = a.get(aKey);
                Object bValue = b.get(aKey);
                this.compareTwoObjects(aValue, bValue);
            } else {
                this.difference("Map B does not contain key from map A: %s", aKey.toString());
            }
            this.breadcrumbs.pop();
        }
        Object missingEntryA = a.getNoEntryValue();
        if (!Objects.equals(missingEntryA, missingEntryB = b.getNoEntryValue())) {
            this.difference("No-entry value differs between two maps: %s vs. %s", missingEntryA.toString(), missingEntryB.toString());
        }
    }

    private Object extractKeys(Object object, KeyExtractor keyExtractor) {
        if (!(object instanceof Map)) {
            return object;
        }
        Map originalMap = (Map)object;
        HashMap replacementMap = new HashMap();
        originalMap.forEach((key, value) -> {
            Object replacementKey = keyExtractor.extractKey(key);
            replacementMap.put(replacementKey, value);
        });
        return replacementMap;
    }

    private void compareArrays(Object a, Object b) {
        if (Array.getLength(a) != Array.getLength(b)) {
            this.difference("Array lengths do not match.", new Object[0]);
            return;
        }
        for (int i = 0; i < Array.getLength(a); ++i) {
            this.breadcrumbs.push(i);
            this.compareTwoObjects(Array.get(a, i), Array.get(b, i));
            this.breadcrumbs.pop();
        }
    }

    private void compareCollections(Collection a, Collection b) {
        if (a.size() != b.size()) {
            this.difference("Collections differ in size: %d vs %d", a.size(), b.size());
            return;
        }
        if (a instanceof Set) {
            if (!a.equals(b)) {
                this.difference("Sets are not equal.", new Object[0]);
                return;
            }
        } else {
            Iterator leftIterator = a.iterator();
            Iterator rightIterator = b.iterator();
            int i = 0;
            while (leftIterator.hasNext()) {
                this.breadcrumbs.push(i);
                this.compareTwoObjects(leftIterator.next(), rightIterator.next());
                this.breadcrumbs.pop();
                ++i;
            }
        }
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                if (this.ignoreFields.contains(field.getName()) || this.skipTransientFields && Modifier.isTransient(field.getModifiers())) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private void difference(String format, Object ... args) {
        ++this.nDifferences;
        System.out.println(String.format(format, args));
        System.out.println("Comparison stack (outermost first):");
        for (Object e : this.breadcrumbs) {
            System.out.println("    " + e.toString());
        }
        System.out.println();
        if (this.nDifferences > 200) {
            throw new RuntimeException("Too many differences.");
        }
    }

    public boolean hasDifferences() {
        return this.nDifferences > 0;
    }

    public void printSummary() {
        System.out.println("Maximum recursion depth was " + this.maxDepthReached);
        System.out.println("Number of objects compared was " + this.nObjectsCompared);
        System.out.println("Number of differences found was " + this.nDifferences);
    }
}

