/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import gnu.trove.map.hash.TIntIntHashMap;

public class TIntIntHashMapSerializer
extends Serializer<TIntIntHashMap> {
    private final boolean optimizePositive = true;
    private final boolean varInts = true;

    public void write(Kryo kryo, Output output, TIntIntHashMap map) {
        output.writeVarInt(map.getNoEntryKey(), false);
        output.writeVarInt(map.getNoEntryValue(), false);
        output.writeVarInt(map.size(), true);
        map.forEachEntry((k, v) -> {
            output.writeVarInt(k, true);
            output.writeVarInt(v, true);
            return true;
        });
    }

    public TIntIntHashMap read(Kryo kryo, Input input, Class type) {
        int noEntryKey = input.readVarInt(false);
        int noEntryVal = input.readVarInt(false);
        int size = input.readVarInt(true);
        TIntIntHashMap map = new TIntIntHashMap(size, 0.5f, noEntryKey, noEntryVal);
        for (int i = 0; i < size; ++i) {
            int key = input.readVarInt(true);
            int val = input.readVarInt(true);
            map.put(key, val);
        }
        return map;
    }

    private /* synthetic */ boolean lambda$write$1(Output output, int k, int v) {
        output.writeInt(k, true);
        output.writeInt(v, true);
        return true;
    }
}

