/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import gnu.trove.list.array.TIntArrayList;

public class TIntArrayListSerializer
extends Serializer<TIntArrayList> {
    private final boolean optimizePositive = false;
    private final boolean varInts = true;

    public void write(Kryo kryo, Output output, TIntArrayList list) {
        output.writeVarInt(list.getNoEntryValue(), false);
        output.writeVarInt(list.size(), true);
        for (int i = 0; i < list.size(); ++i) {
            output.writeVarInt(list.get(i), false);
        }
    }

    public TIntArrayList read(Kryo kryo, Input input, Class type) {
        int noEntryValue = input.readVarInt(false);
        int length = input.readVarInt(true);
        TIntArrayList list = new TIntArrayList(length, noEntryValue);
        for (int i = 0; i < length; ++i) {
            list.add(input.readVarInt(false));
        }
        return list;
    }
}

