/*
 * Decompiled with CFR 0.152.
 */
package com.coreoz.wisp.schedule;

import com.coreoz.wisp.schedule.Schedule;

public class OnceSchedule
implements Schedule {
    private final Schedule baseSchedule;
    private Integer initialExecutionsCount;

    public OnceSchedule(Schedule baseSchedule) {
        this.baseSchedule = baseSchedule;
        this.initialExecutionsCount = null;
    }

    @Override
    public long nextExecutionInMillis(long currentTimeInMillis, int executionsCount, Long lastExecutionTimeInMillis) {
        if (this.initialExecutionsCount == null) {
            this.initialExecutionsCount = executionsCount;
        }
        if (this.initialExecutionsCount < executionsCount) {
            return -1L;
        }
        return this.baseSchedule.nextExecutionInMillis(currentTimeInMillis, executionsCount, lastExecutionTimeInMillis);
    }

    public Schedule baseSchedule() {
        return this.baseSchedule;
    }

    public String toString() {
        return "once, " + this.baseSchedule;
    }
}

