/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.AckMode;
import com.corundumstudio.socketio.AuthorizationListener;
import com.corundumstudio.socketio.JsonSupportWrapper;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.handler.SuccessAuthorizationListener;
import com.corundumstudio.socketio.listener.DefaultExceptionListener;
import com.corundumstudio.socketio.listener.ExceptionListener;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.store.MemoryStoreFactory;
import com.corundumstudio.socketio.store.StoreFactory;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;

public class Configuration {
    private ExceptionListener exceptionListener = new DefaultExceptionListener();
    private String context = "/socket.io";
    private List<Transport> transports = Arrays.asList(Transport.WEBSOCKET, Transport.POLLING);
    private int bossThreads = 0;
    private int workerThreads = 0;
    private boolean useLinuxNativeEpoll;
    private boolean allowCustomRequests = false;
    private int upgradeTimeout = 10000;
    private int pingTimeout = 60000;
    private int pingInterval = 25000;
    private int firstDataTimeout = 5000;
    private int maxHttpContentLength = 65536;
    private int maxFramePayloadLength = 65536;
    private String packagePrefix;
    private String hostname;
    private int port = -1;
    private String sslProtocol = "TLSv1";
    private String keyStoreFormat = "JKS";
    private InputStream keyStore;
    private String keyStorePassword;
    private String trustStoreFormat = "JKS";
    private InputStream trustStore;
    private String trustStorePassword;
    private String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private boolean preferDirectBuffer = true;
    private SocketConfig socketConfig = new SocketConfig();
    private StoreFactory storeFactory = new MemoryStoreFactory();
    private JsonSupport jsonSupport;
    private AuthorizationListener authorizationListener = new SuccessAuthorizationListener();
    private AckMode ackMode = AckMode.AUTO_SUCCESS_ONLY;
    private boolean addVersionHeader = true;
    private String origin;
    private boolean httpCompression = true;
    private boolean websocketCompression = true;

    public Configuration() {
    }

    Configuration(Configuration conf) {
        this.setBossThreads(conf.getBossThreads());
        this.setWorkerThreads(conf.getWorkerThreads());
        this.setUseLinuxNativeEpoll(conf.isUseLinuxNativeEpoll());
        this.setPingInterval(conf.getPingInterval());
        this.setPingTimeout(conf.getPingTimeout());
        this.setHostname(conf.getHostname());
        this.setPort(conf.getPort());
        if (conf.getJsonSupport() == null) {
            try {
                this.getClass().getClassLoader().loadClass("com.fasterxml.jackson.databind.ObjectMapper");
                try {
                    Class<?> jjs = this.getClass().getClassLoader().loadClass("com.corundumstudio.socketio.protocol.JacksonJsonSupport");
                    JsonSupport js = (JsonSupport)jjs.getConstructor(new Class[0]).newInstance(new Object[0]);
                    conf.setJsonSupport(js);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't find jackson lib in classpath", e);
            }
        }
        this.setJsonSupport(new JsonSupportWrapper(conf.getJsonSupport()));
        this.setContext(conf.getContext());
        this.setAllowCustomRequests(conf.isAllowCustomRequests());
        this.setKeyStorePassword(conf.getKeyStorePassword());
        this.setKeyStore(conf.getKeyStore());
        this.setKeyStoreFormat(conf.getKeyStoreFormat());
        this.setTrustStore(conf.getTrustStore());
        this.setTrustStoreFormat(conf.getTrustStoreFormat());
        this.setTrustStorePassword(conf.getTrustStorePassword());
        this.setKeyManagerFactoryAlgorithm(conf.getKeyManagerFactoryAlgorithm());
        this.setTransports(conf.getTransports().toArray(new Transport[conf.getTransports().size()]));
        this.setMaxHttpContentLength(conf.getMaxHttpContentLength());
        this.setPackagePrefix(conf.getPackagePrefix());
        this.setPreferDirectBuffer(conf.isPreferDirectBuffer());
        this.setStoreFactory(conf.getStoreFactory());
        this.setAuthorizationListener(conf.getAuthorizationListener());
        this.setExceptionListener(conf.getExceptionListener());
        this.setSocketConfig(conf.getSocketConfig());
        this.setAckMode(conf.getAckMode());
        this.setMaxFramePayloadLength(conf.getMaxFramePayloadLength());
        this.setUpgradeTimeout(conf.getUpgradeTimeout());
        this.setAddVersionHeader(conf.isAddVersionHeader());
        this.setOrigin(conf.getOrigin());
        this.setSSLProtocol(conf.getSSLProtocol());
        this.setHttpCompression(conf.isHttpCompression());
        this.setWebsocketCompression(conf.isWebsocketCompression());
    }

    public JsonSupport getJsonSupport() {
        return this.jsonSupport;
    }

    public void setJsonSupport(JsonSupport jsonSupport) {
        this.jsonSupport = jsonSupport;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBossThreads() {
        return this.bossThreads;
    }

    public void setBossThreads(int bossThreads) {
        this.bossThreads = bossThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setPingInterval(int heartbeatIntervalSecs) {
        this.pingInterval = heartbeatIntervalSecs;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void setPingTimeout(int heartbeatTimeoutSecs) {
        this.pingTimeout = heartbeatTimeoutSecs;
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public boolean isHeartbeatsEnabled() {
        return this.pingTimeout > 0;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isAllowCustomRequests() {
        return this.allowCustomRequests;
    }

    public void setAllowCustomRequests(boolean allowCustomRequests) {
        this.allowCustomRequests = allowCustomRequests;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStore(InputStream keyStore) {
        this.keyStore = keyStore;
    }

    public InputStream getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setMaxHttpContentLength(int value) {
        this.maxHttpContentLength = value;
    }

    public int getMaxHttpContentLength() {
        return this.maxHttpContentLength;
    }

    public void setTransports(Transport ... transports) {
        if (transports.length == 0) {
            throw new IllegalArgumentException("Transports list can't be empty");
        }
        this.transports = Arrays.asList(transports);
    }

    public List<Transport> getTransports() {
        return this.transports;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public void setPreferDirectBuffer(boolean preferDirectBuffer) {
        this.preferDirectBuffer = preferDirectBuffer;
    }

    public boolean isPreferDirectBuffer() {
        return this.preferDirectBuffer;
    }

    public void setStoreFactory(StoreFactory clientStoreFactory) {
        this.storeFactory = clientStoreFactory;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setAuthorizationListener(AuthorizationListener authorizationListener) {
        this.authorizationListener = authorizationListener;
    }

    public AuthorizationListener getAuthorizationListener() {
        return this.authorizationListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    public void setSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
    }

    public void setAckMode(AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public String getTrustStoreFormat() {
        return this.trustStoreFormat;
    }

    public void setTrustStoreFormat(String trustStoreFormat) {
        this.trustStoreFormat = trustStoreFormat;
    }

    public InputStream getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(InputStream trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
    }

    public void setMaxFramePayloadLength(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public int getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public void setUpgradeTimeout(int upgradeTimeout) {
        this.upgradeTimeout = upgradeTimeout;
    }

    public int getUpgradeTimeout() {
        return this.upgradeTimeout;
    }

    public void setAddVersionHeader(boolean addVersionHeader) {
        this.addVersionHeader = addVersionHeader;
    }

    public boolean isAddVersionHeader() {
        return this.addVersionHeader;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getOrigin() {
        return this.origin;
    }

    public boolean isUseLinuxNativeEpoll() {
        return this.useLinuxNativeEpoll;
    }

    public void setUseLinuxNativeEpoll(boolean useLinuxNativeEpoll) {
        this.useLinuxNativeEpoll = useLinuxNativeEpoll;
    }

    public void setSSLProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSSLProtocol() {
        return this.sslProtocol;
    }

    public void setFirstDataTimeout(int firstDataTimeout) {
        this.firstDataTimeout = firstDataTimeout;
    }

    public int getFirstDataTimeout() {
        return this.firstDataTimeout;
    }

    public void setHttpCompression(boolean httpCompression) {
        this.httpCompression = httpCompression;
    }

    public boolean isHttpCompression() {
        return this.httpCompression;
    }

    public void setWebsocketCompression(boolean websocketCompression) {
        this.websocketCompression = websocketCompression;
    }

    public boolean isWebsocketCompression() {
        return this.websocketCompression;
    }
}

