/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.protocol.AckArgs;
import com.corundumstudio.socketio.protocol.Event;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketEncoder;
import com.corundumstudio.socketio.protocol.PacketType;
import com.corundumstudio.socketio.protocol.UTF8CharsScanner;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedList;

public class PacketDecoder {
    private final UTF8CharsScanner utf8scanner = new UTF8CharsScanner();
    private final ByteBuf QUOTES = Unpooled.copiedBuffer((CharSequence)"\"", (Charset)CharsetUtil.UTF_8);
    private final JsonSupport jsonSupport;
    private final AckManager ackManager;

    public PacketDecoder(JsonSupport jsonSupport, AckManager ackManager) {
        this.jsonSupport = jsonSupport;
        this.ackManager = ackManager;
    }

    private boolean isStringPacket(ByteBuf content) {
        return content.getByte(content.readerIndex()) == 0;
    }

    public ByteBuf preprocessJson(Integer jsonIndex, ByteBuf content) throws IOException {
        String packet = URLDecoder.decode(content.toString(CharsetUtil.UTF_8), CharsetUtil.UTF_8.name());
        if (jsonIndex != null) {
            packet = packet.replace("\\\\n", "\\n");
            packet = packet.substring(2);
        }
        return Unpooled.wrappedBuffer((byte[])packet.getBytes(CharsetUtil.UTF_8));
    }

    private long readLong(ByteBuf chars, int length) {
        long result = 0L;
        for (int i = chars.readerIndex(); i < chars.readerIndex() + length; ++i) {
            int digit = chars.getByte(i) & 0xF;
            for (int j = 0; j < chars.readerIndex() + length - 1 - i; ++j) {
                digit *= 10;
            }
            result += (long)digit;
        }
        chars.readerIndex(chars.readerIndex() + length);
        return result;
    }

    private PacketType readType(ByteBuf buffer) {
        int typeId = buffer.readByte() & 0xF;
        return PacketType.valueOf(typeId);
    }

    private PacketType readInnerType(ByteBuf buffer) {
        int typeId = buffer.readByte() & 0xF;
        return PacketType.valueOfInner(typeId);
    }

    private boolean hasLengthHeader(ByteBuf buffer) {
        for (int i = 0; i < Math.min(buffer.readableBytes(), 10); ++i) {
            byte b = buffer.getByte(buffer.readerIndex() + i);
            if (b == 58 && i > 0) {
                return true;
            }
            if (b <= 57 && b >= 48) continue;
            return false;
        }
        return false;
    }

    public Packet decodePackets(ByteBuf buffer, ClientHead client) throws IOException {
        if (this.isStringPacket(buffer)) {
            int maxLength = Math.min(buffer.readableBytes(), 10);
            int headEndIndex = buffer.bytesBefore(maxLength, (byte)-1);
            if (headEndIndex == -1) {
                headEndIndex = buffer.bytesBefore(maxLength, (byte)63);
            }
            int len = (int)this.readLong(buffer, headEndIndex);
            ByteBuf frame = buffer.slice(buffer.readerIndex() + 1, len);
            buffer.readerIndex(buffer.readerIndex() + 1 + len);
            return this.decode(client, frame);
        }
        if (this.hasLengthHeader(buffer)) {
            int lengthEndIndex = buffer.bytesBefore((byte)58);
            int lenHeader = (int)this.readLong(buffer, lengthEndIndex);
            int len = this.utf8scanner.getActualLength(buffer, lenHeader);
            ByteBuf frame = buffer.slice(buffer.readerIndex() + 1, len);
            buffer.readerIndex(buffer.readerIndex() + 1 + len);
            return this.decode(client, frame);
        }
        return this.decode(client, buffer);
    }

    private String readString(ByteBuf frame) {
        return this.readString(frame, frame.readableBytes());
    }

    private String readString(ByteBuf frame, int size) {
        byte[] bytes = new byte[size];
        frame.readBytes(bytes);
        return new String(bytes, CharsetUtil.UTF_8);
    }

    private Packet decode(ClientHead head, ByteBuf frame) throws IOException {
        if (frame.getByte(0) == 98 && frame.getByte(1) == 52 || frame.getByte(0) == 4 || frame.getByte(0) == 1) {
            return this.parseBinary(head, frame);
        }
        PacketType type = this.readType(frame);
        Packet packet = new Packet(type, head.getEngineIOVersion());
        if (type == PacketType.PING) {
            packet.setData(this.readString(frame));
            return packet;
        }
        if (!frame.isReadable()) {
            return packet;
        }
        PacketType innerType = this.readInnerType(frame);
        packet.setSubType(innerType);
        this.parseHeader(frame, packet, innerType);
        this.parseBody(head, frame, packet);
        return packet;
    }

    private void parseHeader(ByteBuf frame, Packet packet, PacketType innerType) {
        boolean hasNsp;
        boolean hasAttachments;
        int endIndex = frame.bytesBefore((byte)91);
        if (endIndex <= 0) {
            return;
        }
        int attachmentsDividerIndex = frame.bytesBefore(endIndex, (byte)45);
        boolean bl = hasAttachments = attachmentsDividerIndex != -1;
        if (hasAttachments && (PacketType.BINARY_EVENT.equals((Object)innerType) || PacketType.BINARY_ACK.equals((Object)innerType))) {
            int attachments = (int)this.readLong(frame, attachmentsDividerIndex);
            packet.initAttachments(attachments);
            frame.readerIndex(frame.readerIndex() + 1);
            endIndex -= attachmentsDividerIndex + 1;
        }
        if (endIndex == 0) {
            return;
        }
        boolean bl2 = hasNsp = frame.bytesBefore(endIndex, (byte)44) != -1;
        if (hasNsp) {
            String nspAckId = this.readString(frame, endIndex);
            String[] parts = nspAckId.split(",");
            String nsp = parts[0];
            packet.setNsp(nsp);
            if (parts.length > 1) {
                String ackId = parts[1];
                packet.setAckId(Long.valueOf(ackId));
            }
        } else {
            long ackId = this.readLong(frame, endIndex);
            packet.setAckId(ackId);
        }
    }

    private Packet parseBinary(ClientHead head, ByteBuf frame) throws IOException {
        if (frame.getByte(0) == 1) {
            frame.readByte();
            int headEndIndex = frame.bytesBefore((byte)-1);
            int len = (int)this.readLong(frame, headEndIndex);
            ByteBuf oldFrame = frame;
            frame = frame.slice(oldFrame.readerIndex() + 1, len);
            oldFrame.readerIndex(oldFrame.readerIndex() + 1 + len);
        }
        if (frame.getByte(0) == 98 && frame.getByte(1) == 52) {
            frame.readShort();
        } else if (frame.getByte(0) == 4) {
            frame.readByte();
        }
        Packet binaryPacket = head.getLastBinaryPacket();
        if (binaryPacket != null) {
            if (frame.getByte(0) == 98 && frame.getByte(1) == 52) {
                binaryPacket.addAttachment(Unpooled.copiedBuffer((ByteBuf)frame));
            } else {
                ByteBuf attachBuf = Base64.encode((ByteBuf)frame);
                binaryPacket.addAttachment(Unpooled.copiedBuffer((ByteBuf)attachBuf));
                attachBuf.release();
            }
            frame.readerIndex(frame.readerIndex() + frame.readableBytes());
            if (binaryPacket.isAttachmentsLoaded()) {
                LinkedList<ByteBuf> slices = new LinkedList<ByteBuf>();
                ByteBuf source = binaryPacket.getDataSource();
                for (int i = 0; i < binaryPacket.getAttachments().size(); ++i) {
                    ByteBuf attachment = binaryPacket.getAttachments().get(i);
                    ByteBuf scanValue = Unpooled.copiedBuffer((CharSequence)("{\"_placeholder\":true,\"num\":" + i + "}"), (Charset)CharsetUtil.UTF_8);
                    int pos = PacketEncoder.find(source, scanValue);
                    if (pos == -1 && (pos = PacketEncoder.find(source, scanValue = Unpooled.copiedBuffer((CharSequence)("{\"num\":" + i + ",\"_placeholder\":true}"), (Charset)CharsetUtil.UTF_8))) == -1) {
                        throw new IllegalStateException("Can't find attachment by index: " + i + " in packet source");
                    }
                    ByteBuf prefixBuf = source.slice(source.readerIndex(), pos - source.readerIndex());
                    slices.add(prefixBuf);
                    slices.add(this.QUOTES);
                    slices.add(attachment);
                    slices.add(this.QUOTES);
                    source.readerIndex(pos + scanValue.readableBytes());
                }
                slices.add(source.slice());
                ByteBuf compositeBuf = Unpooled.wrappedBuffer((ByteBuf[])slices.toArray(new ByteBuf[slices.size()]));
                this.parseBody(head, compositeBuf, binaryPacket);
                head.setLastBinaryPacket(null);
                return binaryPacket;
            }
        }
        return new Packet(PacketType.MESSAGE, head.getEngineIOVersion());
    }

    private void parseBody(ClientHead head, ByteBuf frame, Packet packet) throws IOException {
        if (packet.getType() == PacketType.MESSAGE) {
            ByteBufInputStream in;
            if (packet.getSubType() == PacketType.CONNECT || packet.getSubType() == PacketType.DISCONNECT) {
                packet.setNsp(this.readNamespace(frame));
            }
            if (packet.hasAttachments() && !packet.isAttachmentsLoaded()) {
                packet.setDataSource(Unpooled.copiedBuffer((ByteBuf)frame));
                frame.readerIndex(frame.readableBytes());
                head.setLastBinaryPacket(packet);
                return;
            }
            if (packet.getSubType() == PacketType.ACK || packet.getSubType() == PacketType.BINARY_ACK) {
                in = new ByteBufInputStream(frame);
                AckCallback<?> callback = this.ackManager.getCallback(head.getSessionId(), packet.getAckId());
                AckArgs args = this.jsonSupport.readAckArgs(in, callback);
                packet.setData(args.getArgs());
            }
            if (packet.getSubType() == PacketType.EVENT || packet.getSubType() == PacketType.BINARY_EVENT) {
                in = new ByteBufInputStream(frame);
                Event event = this.jsonSupport.readValue(packet.getNsp(), in, Event.class);
                packet.setName(event.getName());
                packet.setData(event.getArgs());
            }
        }
    }

    private String readNamespace(ByteBuf frame) {
        ByteBuf buffer = frame.slice();
        frame.readerIndex(frame.readerIndex() + frame.readableBytes());
        int endIndex = buffer.bytesBefore((byte)63);
        if (endIndex > 0) {
            return this.readString(buffer, endIndex);
        }
        endIndex = buffer.bytesBefore((byte)44);
        if (endIndex > 0) {
            return this.readString(buffer, endIndex);
        }
        return this.readString(buffer);
    }
}

