/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.handler.ClientsBox;
import com.corundumstudio.socketio.messages.PacketsMessage;
import com.corundumstudio.socketio.protocol.EngineIOVersion;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketTransport
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "websocket";
    private static final Logger log = LoggerFactory.getLogger(WebSocketTransport.class);
    private final AuthorizeHandler authorizeHandler;
    private final CancelableScheduler scheduler;
    private final Configuration configuration;
    private final ClientsBox clientsBox;
    private final boolean isSsl;

    public WebSocketTransport(boolean isSsl, AuthorizeHandler authorizeHandler, Configuration configuration, CancelableScheduler scheduler, ClientsBox clientsBox) {
        this.isSsl = isSsl;
        this.authorizeHandler = authorizeHandler;
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.clientsBox = clientsBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CloseWebSocketFrame) {
            ctx.channel().writeAndFlush(msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        } else if (msg instanceof BinaryWebSocketFrame || msg instanceof TextWebSocketFrame) {
            ByteBufHolder frame = (ByteBufHolder)msg;
            ClientHead client = this.clientsBox.get(ctx.channel());
            if (client == null) {
                log.debug("Client with was already disconnected. Channel closed!");
                ctx.channel().close();
                frame.release();
                return;
            }
            ctx.pipeline().fireChannelRead((Object)new PacketsMessage(client, frame.content(), Transport.WEBSOCKET));
            frame.release();
            return;
        } else if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.uri());
            String path = queryDecoder.path();
            List transport = (List)queryDecoder.parameters().get("transport");
            List sid = (List)queryDecoder.parameters().get("sid");
            if (transport != null && NAME.equals(transport.get(0))) {
                try {
                    if (!this.configuration.getTransports().contains((Object)Transport.WEBSOCKET)) {
                        log.debug("{} transport not supported by configuration.", (Object)Transport.WEBSOCKET);
                        ctx.channel().close();
                        return;
                    }
                    if (sid != null && sid.get(0) != null) {
                        UUID sessionId = UUID.fromString((String)sid.get(0));
                        this.handshake(ctx, sessionId, path, req);
                        return;
                    }
                    ClientHead client = (ClientHead)ctx.channel().attr(ClientHead.CLIENT).get();
                    if (client == null) return;
                    this.handshake(ctx, client.getSessionId(), path, req);
                    return;
                }
                finally {
                    req.release();
                }
            } else {
                ctx.fireChannelRead(msg);
            }
            return;
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ClientHead client = this.clientsBox.get(ctx.channel());
        if (client != null && client.isTransportChannel(ctx.channel(), Transport.WEBSOCKET)) {
            ctx.flush();
        } else {
            super.channelReadComplete(ctx);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        ClientHead client = this.clientsBox.get(channel);
        Packet packet = new Packet(PacketType.MESSAGE, client != null ? client.getEngineIOVersion() : EngineIOVersion.UNKNOWN);
        packet.setSubType(PacketType.DISCONNECT);
        if (client != null && client.isTransportChannel(ctx.channel(), Transport.WEBSOCKET)) {
            log.debug("channel inactive {}", (Object)client.getSessionId());
            client.onChannelDisconnect();
        }
        super.channelInactive(ctx);
        if (client != null) {
            client.send(packet);
        }
        channel.close();
        ctx.close();
    }

    private void handshake(ChannelHandlerContext ctx, final UUID sessionId, String path, FullHttpRequest req) {
        final Channel channel = ctx.channel();
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation((HttpRequest)req), null, true, this.configuration.getMaxFramePayloadLength());
        WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)req);
        if (handshaker != null) {
            try {
                ChannelFuture f = handshaker.handshake(channel, req);
                f.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            log.error("Can't handshake {}", (Object)sessionId, (Object)future.cause());
                            WebSocketTransport.this.closeClient(sessionId, channel);
                            return;
                        }
                        channel.pipeline().addBefore("webSocketTransport", "webSocketAggregator", (ChannelHandler)new WebSocketFrameAggregator(WebSocketTransport.this.configuration.getMaxFramePayloadLength()));
                        WebSocketTransport.this.connectClient(channel, sessionId);
                    }
                });
            }
            catch (Throwable e) {
                log.warn("Can't handshake {}, {}", new Object[]{sessionId, e.getMessage(), e});
                this.closeClient(sessionId, channel);
            }
        } else {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        }
    }

    private void closeClient(UUID sessionId, Channel channel) {
        try {
            channel.close();
        }
        catch (Throwable t) {
            log.warn("Can't close channel for sessionId: {}", (Object)sessionId, (Object)t);
        }
        ClientHead clientHead = this.clientsBox.get(sessionId);
        if (clientHead != null && clientHead.getNamespaces().isEmpty()) {
            this.clientsBox.removeClient(sessionId);
            clientHead.disconnect();
        }
        log.info("Client with sessionId: {} was disconnected", (Object)sessionId);
    }

    private void connectClient(Channel channel, final UUID sessionId) {
        ClientHead client = this.clientsBox.get(sessionId);
        if (client == null) {
            log.warn("Unauthorized client with sessionId: {} with ip: {}. Channel closed!", (Object)sessionId, (Object)channel.remoteAddress());
            this.closeClient(sessionId, channel);
            return;
        }
        client.bindChannel(channel, Transport.WEBSOCKET);
        this.authorizeHandler.connect(client);
        if (client.getCurrentTransport() == Transport.POLLING) {
            SchedulerKey key = new SchedulerKey(SchedulerKey.Type.UPGRADE_TIMEOUT, sessionId);
            this.scheduler.schedule(key, new Runnable(){

                @Override
                public void run() {
                    ClientHead clientHead = WebSocketTransport.this.clientsBox.get(sessionId);
                    if (clientHead != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("client did not complete upgrade - closing transport");
                        }
                        clientHead.onChannelDisconnect();
                    }
                }
            }, this.configuration.getUpgradeTimeout(), TimeUnit.MILLISECONDS);
        }
        log.debug("\u0441lient {} handshake completed", (Object)sessionId);
    }

    private String getWebSocketLocation(HttpRequest req) {
        String protocol = "ws://";
        if (this.isSsl) {
            protocol = "wss://";
        }
        return protocol + req.headers().get((CharSequence)HttpHeaderNames.HOST) + req.uri();
    }
}

