/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.Disconnectable;
import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.handler.ClientsBox;
import com.corundumstudio.socketio.handler.EncoderHandler;
import com.corundumstudio.socketio.messages.HttpErrorMessage;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.protocol.AuthPacket;
import com.corundumstudio.socketio.protocol.EngineIOVersion;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.ConnectMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import com.corundumstudio.socketio.transport.NamespaceClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class AuthorizeHandler
extends ChannelInboundHandlerAdapter
implements Disconnectable {
    private static final Logger log = LoggerFactory.getLogger(AuthorizeHandler.class);
    private final CancelableScheduler scheduler;
    private final String connectPath;
    private final Configuration configuration;
    private final NamespacesHub namespacesHub;
    private final StoreFactory storeFactory;
    private final DisconnectableHub disconnectable;
    private final AckManager ackManager;
    private final ClientsBox clientsBox;

    public AuthorizeHandler(String connectPath, CancelableScheduler scheduler, Configuration configuration, NamespacesHub namespacesHub, StoreFactory storeFactory, DisconnectableHub disconnectable, AckManager ackManager, ClientsBox clientsBox) {
        this.connectPath = connectPath;
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.namespacesHub = namespacesHub;
        this.storeFactory = storeFactory;
        this.disconnectable = disconnectable;
        this.ackManager = ackManager;
        this.clientsBox = clientsBox;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.PING_TIMEOUT, ctx.channel());
        this.scheduler.schedule(key, new Runnable(){

            @Override
            public void run() {
                ctx.channel().close();
                log.debug("Client with ip {} opened channel but doesn't send any data! Channel closed!", (Object)ctx.channel().remoteAddress());
            }
        }, this.configuration.getFirstDataTimeout(), TimeUnit.MILLISECONDS);
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.PING_TIMEOUT, ctx.channel());
        this.scheduler.cancel(key);
        if (msg instanceof FullHttpRequest) {
            String origin;
            FullHttpRequest req = (FullHttpRequest)msg;
            Channel channel = ctx.channel();
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.uri());
            if (!this.configuration.isAllowCustomRequests() && !queryDecoder.path().startsWith(this.connectPath)) {
                DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
                channel.writeAndFlush((Object)res).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                req.release();
                return;
            }
            List sid = (List)queryDecoder.parameters().get("sid");
            if (queryDecoder.path().equals(this.connectPath) && sid == null && !this.authorize(ctx, channel, origin = req.headers().get((CharSequence)HttpHeaderNames.ORIGIN), queryDecoder.parameters(), req)) {
                req.release();
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    private boolean authorize(ChannelHandlerContext ctx, Channel channel, String origin, Map<String, List<String>> params, FullHttpRequest req) throws IOException {
        HashMap<String, List> headers = new HashMap<String, List>(req.headers().names().size());
        for (String name : req.headers().names()) {
            List values = req.headers().getAll(name);
            headers.put(name, values);
        }
        HandshakeData data = new HandshakeData(req.headers(), params, (InetSocketAddress)channel.remoteAddress(), (InetSocketAddress)channel.localAddress(), req.uri(), origin != null && !origin.equalsIgnoreCase("null"));
        boolean result = false;
        try {
            result = this.configuration.getAuthorizationListener().isAuthorized(data);
        }
        catch (Exception e) {
            log.error("Authorization error", (Throwable)e);
        }
        if (!result) {
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
            channel.writeAndFlush((Object)res).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            log.debug("Handshake unauthorized, query params: {} headers: {}", params, headers);
            return false;
        }
        UUID sessionId = null;
        sessionId = this.configuration.isRandomSession() ? UUID.randomUUID() : this.generateOrGetSessionIdFromRequest(req.headers());
        List<String> transportValue = params.get("transport");
        if (transportValue == null) {
            log.error("Got no transports for request {}", (Object)req.uri());
            this.writeAndFlushTransportError(channel, origin);
            return false;
        }
        Transport transport = null;
        try {
            transport = Transport.valueOf(transportValue.get(0).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Unknown transport for request {}", (Object)req.uri());
            this.writeAndFlushTransportError(channel, origin);
            return false;
        }
        if (!this.configuration.getTransports().contains((Object)transport)) {
            log.error("Unsupported transport for request {}", (Object)req.uri());
            this.writeAndFlushTransportError(channel, origin);
            return false;
        }
        ClientHead client = new ClientHead(sessionId, this.ackManager, this.disconnectable, this.storeFactory, data, this.clientsBox, transport, this.scheduler, this.configuration, params);
        channel.attr(ClientHead.CLIENT).set((Object)client);
        this.clientsBox.addClient(client);
        String[] transports = new String[]{};
        if (!(!this.configuration.getTransports().contains((Object)Transport.WEBSOCKET) || EngineIOVersion.V4.equals((Object)client.getEngineIOVersion()) && Transport.WEBSOCKET.equals((Object)client.getCurrentTransport()))) {
            transports = new String[]{"websocket"};
        }
        AuthPacket authPacket = new AuthPacket(sessionId, transports, this.configuration.getPingInterval(), this.configuration.getPingTimeout());
        Packet packet = new Packet(PacketType.OPEN, client.getEngineIOVersion());
        packet.setData(authPacket);
        client.send(packet);
        client.schedulePing();
        client.schedulePingTimeout();
        log.debug("Handshake authorized for sessionId: {}, query params: {} headers: {}", new Object[]{sessionId, params, headers});
        return true;
    }

    private void writeAndFlushTransportError(Channel channel, String origin) {
        HashMap<String, Object> errorData = new HashMap<String, Object>();
        errorData.put("code", 0);
        errorData.put("message", "Transport unknown");
        channel.attr(EncoderHandler.ORIGIN).set((Object)origin);
        channel.writeAndFlush((Object)new HttpErrorMessage(errorData));
    }

    private UUID generateOrGetSessionIdFromRequest(HttpHeaders headers) {
        List values = headers.getAll("io");
        if (values.size() == 1) {
            try {
                return UUID.fromString((String)values.get(0));
            }
            catch (IllegalArgumentException iaex) {
                log.warn("Malformed UUID received for session! io=" + (String)values.get(0));
            }
        }
        for (String cookieHeader : headers.getAll((CharSequence)HttpHeaderNames.COOKIE)) {
            Set cookies = ServerCookieDecoder.LAX.decode(cookieHeader);
            for (Cookie cookie : cookies) {
                if (!cookie.name().equals("io")) continue;
                try {
                    return UUID.fromString(cookie.value());
                }
                catch (IllegalArgumentException iaex) {
                    log.warn("Malformed UUID received for session! io=" + cookie.value());
                }
            }
        }
        return UUID.randomUUID();
    }

    public void connect(UUID sessionId) {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.PING_TIMEOUT, sessionId);
        this.scheduler.cancel(key);
    }

    public void connect(ClientHead client) {
        Namespace ns = this.namespacesHub.get("");
        if (!client.getNamespaces().contains(ns)) {
            Packet packet = new Packet(PacketType.MESSAGE, client.getEngineIOVersion());
            packet.setSubType(PacketType.CONNECT);
            if (!EngineIOVersion.V4.equals((Object)client.getEngineIOVersion())) {
                client.send(packet);
            }
            this.configuration.getStoreFactory().pubSubStore().publish(PubSubType.CONNECT, new ConnectMessage(client.getSessionId()));
            NamespaceClient nsClient = client.addNamespaceClient(ns);
            ns.onConnect(nsClient);
        }
    }

    @Override
    public void onDisconnect(ClientHead client) {
        this.clientsBox.removeClient(client.getSessionId());
    }
}

