/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.misc;

import java.util.Iterator;

public class CompositeIterator<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> listIterator;
    private Iterator<T> currentIterator = null;

    public CompositeIterator(Iterator<Iterator<T>> listIterator) {
        this.listIterator = listIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            while (this.listIterator.hasNext()) {
                Iterator<T> iterator = this.listIterator.next();
                if (!iterator.hasNext()) continue;
                this.currentIterator = iterator;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        this.hasNext();
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }
}

