/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format_spi;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Collections;
import java.util.Set;

public final class LineRanges {
    private static final LineRanges ALL = new LineRanges((RangeSet<Integer>)TreeRangeSet.create(Collections.singleton(Range.all())));
    private final RangeSet<Integer> rangeSet;

    private LineRanges(RangeSet<Integer> rangeSet) {
        if (rangeSet.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one range");
        }
        this.rangeSet = rangeSet;
    }

    public static LineRanges all() {
        return ALL;
    }

    public static LineRanges of(Set<Range<Integer>> ranges) {
        return new LineRanges((RangeSet<Integer>)TreeRangeSet.create(ranges));
    }

    public static LineRanges singleton(Range<Integer> range) {
        return new LineRanges((RangeSet<Integer>)TreeRangeSet.create(Collections.singleton(range)));
    }

    public boolean isAll() {
        return this == ALL;
    }

    public RangeSet<Integer> rangeSet() {
        return this.rangeSet;
    }

    public static LineRanges concat(LineRanges lineRanges1, LineRanges lineRanges2) {
        if (lineRanges1.isAll()) {
            return lineRanges1;
        }
        if (lineRanges2.isAll()) {
            return lineRanges2;
        }
        TreeRangeSet newRangeSet = TreeRangeSet.create();
        newRangeSet.addAll(lineRanges1.rangeSet);
        newRangeSet.addAll(lineRanges2.rangeSet);
        return new LineRanges((RangeSet<Integer>)newRangeSet);
    }

    public String toString() {
        return this.rangeSet.toString();
    }
}

