/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.graph.generator;

import com.cosium.spring.data.jpa.graph.generator.Composer;
import com.cosium.spring.data.jpa.graph.generator.Constants;
import com.cosium.spring.data.jpa.graph.generator.EntityGraphClassName;
import com.cosium.spring.data.jpa.graph.generator.MetamodelAttributeTarget;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;

public class RootComposer
implements Composer {
    private static final String SIMPLE_NAME = "RootComposer";
    private final ClassName entityGraphClassName;
    private final TypeSpec.Builder typeSpecBuilder;
    private boolean referencesLeafComposer;

    public RootComposer(ClassName entityGraphClassName) {
        this.entityGraphClassName = entityGraphClassName;
        FieldSpec entityGraphTypeField = FieldSpec.builder((TypeName)Constants.ENTITY_GRAPH_TYPE_CLASS_NAME, (String)"entityGraphType", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        ParameterizedTypeName listOfString = ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
        ParameterizedTypeName listOfListOfString = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{listOfString});
        FieldSpec entityGraphAttributePathsField = FieldSpec.builder((TypeName)listOfListOfString, (String)"entityGraphAttributePaths", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("this($T.$N)", new Object[]{Constants.ENTITY_GRAPH_TYPE_CLASS_NAME, "LOAD"}).build();
        MethodSpec constructorWithEntityGraphType = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)Constants.ENTITY_GRAPH_TYPE_CLASS_NAME, "entityGraphType", new Modifier[0]).addStatement("this.entityGraphType = entityGraphType", new Object[0]).addStatement("entityGraphAttributePaths = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{listOfString})}).build();
        MethodSpec buildMethod = MethodSpec.methodBuilder((String)"____").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)entityGraphClassName).addStatement("return new $T(this)", new Object[]{entityGraphClassName}).build();
        this.typeSpecBuilder = TypeSpec.classBuilder((String)SIMPLE_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addField(entityGraphTypeField).addField(entityGraphAttributePathsField).addMethod(constructor).addMethod(constructorWithEntityGraphType).addMethod(buildMethod);
    }

    public String simpleName() {
        return SIMPLE_NAME;
    }

    public TypeSpec toTypeSpec() {
        return this.typeSpecBuilder.build();
    }

    @Override
    public void addPath(Elements elements, MetamodelAttributeTarget target) {
        if (target.isEntity() || target.isEmbeddable()) {
            this.addPathToEntity(elements, target);
        } else {
            this.referencesLeafComposer = true;
            this.addPathToLeafComposer(target);
        }
    }

    @Override
    public boolean referencesLeafComposer() {
        return this.referencesLeafComposer;
    }

    private void addPathToEntity(Elements elements, MetamodelAttributeTarget target) {
        ParameterizedTypeName targetNodeComposer = ParameterizedTypeName.get((ClassName)new EntityGraphClassName(elements, target.targetType()).toClassName().nestedClass("NodeComposer"), (TypeName[])new TypeName[]{this.entityGraphClassName.nestedClass(SIMPLE_NAME)});
        this.typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)target.attributeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)targetNodeComposer).addStatement("$T path = new $T()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), ParameterizedTypeName.get(ArrayList.class, (Type[])new Type[]{String.class})}).addStatement("path.add($S)", new Object[]{target.attributeName()}).addStatement("entityGraphAttributePaths.add(path)", new Object[0]).addStatement("return new $T(this, path)", new Object[]{targetNodeComposer}).build());
    }

    private void addPathToLeafComposer(MetamodelAttributeTarget target) {
        ParameterizedTypeName leafComposer = ParameterizedTypeName.get((ClassName)ClassName.get((String)"", (String)"LeafComposer", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)SIMPLE_NAME, (String[])new String[0])});
        this.typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)target.attributeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)leafComposer).addStatement("$T path = new $T()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), ParameterizedTypeName.get(ArrayList.class, (Type[])new Type[]{String.class})}).addStatement("path.add($S)", new Object[]{target.attributeName()}).addStatement("entityGraphAttributePaths.add(path)", new Object[0]).addStatement("return new $T(this)", new Object[]{leafComposer}).build());
    }
}

