/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.graph.generator;

import com.cosium.spring.data.jpa.graph.generator.Constants;
import com.cosium.spring.data.jpa.graph.generator.LeafComposer;
import com.cosium.spring.data.jpa.graph.generator.NodeComposer;
import com.cosium.spring.data.jpa.graph.generator.RootComposer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;

public class EntityGraph {
    private final ClassName className;
    private final TypeSpec typeSpec;

    public EntityGraph(ClassName entityGraphClassName, RootComposer rootComposer, NodeComposer nodeComposer) {
        this.className = entityGraphClassName;
        FieldSpec noopField = FieldSpec.builder((TypeName)entityGraphClassName, (String)"NOOP", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(EntityGraph.NOOP)", new Object[]{entityGraphClassName}).build();
        FieldSpec delegateField = FieldSpec.builder((TypeName)Constants.ENTITY_GRAPH_CLASS_NAME, (String)"delegate", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        ClassName rootComposerClassName = entityGraphClassName.nestedClass(rootComposer.simpleName());
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)rootComposerClassName, "rootComposer", new Modifier[0]).addStatement("this(new $T(rootComposer.entityGraphType, rootComposer.entityGraphAttributePaths.stream().map(pathParts -> String.join(\".\", pathParts)).collect($T.toList())))", new Object[]{Constants.DYNAMIC_ENTITY_GRAPH_CLASS_NAME, Collectors.class}).build();
        MethodSpec emptyConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)Constants.ENTITY_GRAPH_CLASS_NAME, "delegate", new Modifier[0]).addStatement("this.delegate = delegate", new Object[0]).build();
        MethodSpec emptyStaticMethod = MethodSpec.methodBuilder((String)"empty").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)entityGraphClassName).addStatement("return $N().$N()", new Object[]{"____", "____"}).build();
        MethodSpec emptyStaticMethodWithEntityGraphType = MethodSpec.methodBuilder((String)"empty").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)Constants.ENTITY_GRAPH_TYPE_CLASS_NAME, "entityGraphType", new Modifier[0]).returns((TypeName)entityGraphClassName).addStatement("return $N(entityGraphType).$N()", new Object[]{"____", "____"}).build();
        MethodSpec rootStaticMethod = MethodSpec.methodBuilder((String)"____").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)rootComposerClassName).addStatement("return new $N()", new Object[]{rootComposer.simpleName()}).build();
        MethodSpec rootStaticMethodWithEntityGraphType = MethodSpec.methodBuilder((String)"____").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)Constants.ENTITY_GRAPH_TYPE_CLASS_NAME, "entityGraphType", new Modifier[0]).returns((TypeName)rootComposerClassName).addStatement("return new $N(entityGraphType)", new Object[]{rootComposer.simpleName()}).build();
        MethodSpec getEntityGraphTypeMethod = MethodSpec.methodBuilder((String)"buildQueryHint").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)Constants.ENTITY_MANAGER_CLASS_NAME, "entityManager", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), "entityType", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{Constants.ENTITY_GRAPH_QUERY_HINT_CLASS_NAME})).addStatement("return delegate.buildQueryHint(entityManager, entityType)", new Object[0]).build();
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)entityGraphClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)Constants.ENTITY_GRAPH_CLASS_NAME).addField(noopField).addField(delegateField).addMethod(emptyConstructor).addMethod(constructor).addMethod(emptyStaticMethod).addMethod(emptyStaticMethodWithEntityGraphType).addMethod(rootStaticMethod).addMethod(rootStaticMethodWithEntityGraphType).addMethod(getEntityGraphTypeMethod).addType(rootComposer.toTypeSpec()).addType(nodeComposer.toTypeSpec());
        if (rootComposer.referencesLeafComposer() || nodeComposer.referencesLeafComposer()) {
            typeSpecBuilder.addType(new LeafComposer().toTypeSpec());
        }
        this.typeSpec = typeSpecBuilder.build();
    }

    public void writeTo(Filer filer) {
        try {
            JavaFile.builder((String)this.className.packageName(), (TypeSpec)this.typeSpec).build().writeTo(filer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityGraph that = (EntityGraph)o;
        return this.className.equals((Object)that.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }
}

