/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.repository.support.CountQueryDetector;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphBean;
import com.cosium.spring.data.jpa.entity.graph.repository.support.QueryHintsUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;

class RepositoryQueryEntityGraphInjector
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryQueryEntityGraphInjector.class);
    private static final List<String> EXECUTE_QUERY_METHODS = Arrays.asList("getResultList", "getSingleResult", "scroll");
    private static final String UNWRAP_METHOD = "unwrap";
    private final EntityManager entityManager;
    private final EntityGraphBean entityGraphCandidate;

    private RepositoryQueryEntityGraphInjector(EntityManager entityManager, EntityGraphBean entityGraphCandidate) {
        this.entityManager = Objects.requireNonNull(entityManager);
        this.entityGraphCandidate = Objects.requireNonNull(entityGraphCandidate);
    }

    static Query proxy(Query query, EntityManager entityManager, EntityGraphBean entityGraphCandidate) {
        ProxyFactory proxyFactory = new ProxyFactory((Object)query);
        proxyFactory.addAdvice((Advice)new RepositoryQueryEntityGraphInjector(entityManager, entityGraphCandidate));
        return (Query)proxyFactory.getProxy();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String invokedMethodName = invocation.getMethod().getName();
        Object[] invokedMethodArguments = invocation.getArguments();
        if (UNWRAP_METHOD.equals(invocation.getMethod().getName()) && invokedMethodArguments.length == 1 && invokedMethodArguments[0] == null) {
            return invocation.getThis();
        }
        if (EXECUTE_QUERY_METHODS.contains(invokedMethodName)) {
            this.addEntityGraphToQuery((Query)invocation.getThis());
        }
        return invocation.proceed();
    }

    private void addEntityGraphToQuery(Query query) {
        if (CountQueryDetector.isCountQuery()) {
            LOG.trace("CountQuery detected.");
            return;
        }
        if (!this.entityGraphCandidate.isPrimary() && QueryHintsUtils.containsEntityGraph(query.getHints())) {
            LOG.trace("The query hints passed with the find method already hold an entity graph. Overriding aborted because the candidate EntityGraph is optional.");
            return;
        }
        QueryHintsUtils.removeEntityGraphs(query.getHints());
        Map<String, Object> hints = QueryHintsUtils.buildQueryHints(this.entityManager, this.entityGraphCandidate);
        for (Map.Entry<String, Object> hint : hints.entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
    }
}

