/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.domain;

import com.cosium.spring.data.jpa.entity.graph.domain.AbstractEntityGraph;
import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraphType;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DynamicEntityGraph
extends AbstractEntityGraph {
    private final List<String> attributePaths;

    public DynamicEntityGraph(List<String> attributePaths) {
        this.attributePaths = Collections.unmodifiableList(attributePaths);
    }

    public DynamicEntityGraph(EntityGraphType type, List<String> attributePaths) {
        super(type);
        this.attributePaths = Collections.unmodifiableList(attributePaths);
    }

    @Override
    public List<String> getEntityGraphAttributePaths() {
        return this.attributePaths;
    }

    @Override
    public final String getEntityGraphName() {
        return null;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributePaths", this.attributePaths).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicEntityGraph that = (DynamicEntityGraph)o;
        return this.attributePaths.equals(that.attributePaths) && this.getEntityGraphType() == that.getEntityGraphType() && this.isOptional() == that.isOptional();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributePaths, this.getEntityGraphType(), this.isOptional()});
    }
}

