/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraphType;
import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraphUtils;
import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraphs;
import com.cosium.spring.data.jpa.entity.graph.repository.exception.InapplicableEntityGraphException;
import com.cosium.spring.data.jpa.entity.graph.repository.exception.MultipleDefaultEntityGraphException;
import com.cosium.spring.data.jpa.entity.graph.repository.exception.MultipleEntityGraphException;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.ResolvableType;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.util.StringUtils;

class RepositoryMethodEntityGraphExtractor
implements RepositoryProxyPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryMethodEntityGraphExtractor.class);
    private static final ThreadLocal<JpaEntityGraphMethodInterceptor> CURRENT_REPOSITORY = new NamedThreadLocal("Thread local holding the current repository");
    private final EntityManager entityManager;

    RepositoryMethodEntityGraphExtractor(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    static EntityGraphBean getCurrentJpaEntityGraph() {
        JpaEntityGraphMethodInterceptor currentRepository = CURRENT_REPOSITORY.get();
        if (currentRepository == null) {
            return null;
        }
        return currentRepository.getCurrentJpaEntityGraph();
    }

    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)new JpaEntityGraphMethodInterceptor(this.entityManager, repositoryInformation.getDomainType()));
    }

    private static class JpaEntityGraphMethodInterceptor
    implements MethodInterceptor {
        private static final String DEFAULT_ENTITYGRAPH_NAME_SUFFIX = ".default";
        private final Class<?> domainClass;
        private final com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph defaultEntityGraph;
        private final ThreadLocal<EntityGraphBean> currentEntityGraph = new NamedThreadLocal("Thread local holding the current spring data jpa repository entity graph");

        JpaEntityGraphMethodInterceptor(EntityManager entityManager, Class<?> domainClass) {
            this.domainClass = domainClass;
            this.defaultEntityGraph = JpaEntityGraphMethodInterceptor.findDefaultEntityGraph(entityManager, domainClass);
        }

        private static <T> com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph findDefaultEntityGraph(EntityManager entityManager, Class<T> domainClass) {
            com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph defaultEntityGraph = null;
            List entityGraphs = entityManager.getEntityGraphs(domainClass);
            for (EntityGraph entityGraph : entityGraphs) {
                if (!entityGraph.getName().endsWith(DEFAULT_ENTITYGRAPH_NAME_SUFFIX)) continue;
                if (defaultEntityGraph != null) {
                    throw new MultipleDefaultEntityGraphException(entityGraph.getName(), defaultEntityGraph.getEntityGraphName());
                }
                defaultEntityGraph = EntityGraphUtils.fromName(entityGraph.getName(), true);
            }
            return defaultEntityGraph;
        }

        EntityGraphBean getCurrentJpaEntityGraph() {
            return this.currentEntityGraph.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            JpaEntityGraphMethodInterceptor oldRepo = (JpaEntityGraphMethodInterceptor)CURRENT_REPOSITORY.get();
            CURRENT_REPOSITORY.set(this);
            try {
                Object object = this.doInvoke(invocation);
                return object;
            }
            finally {
                CURRENT_REPOSITORY.set(oldRepo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object doInvoke(MethodInvocation invocation) throws Throwable {
            boolean newEntityGraphCandidatePreValidated;
            Object[] arguments = invocation.getArguments();
            com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph providedEntityGraph = null;
            for (Object argument : arguments) {
                if (!(argument instanceof com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph)) continue;
                com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph newEntityGraph = (com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph)argument;
                if (providedEntityGraph != null) {
                    throw new MultipleEntityGraphException("Duplicate EntityGraphs detected. '" + providedEntityGraph + "' and '" + newEntityGraph + "' were passed to method " + invocation.getMethod());
                }
                providedEntityGraph = newEntityGraph;
            }
            Class<?> implementationClass = invocation instanceof ReflectiveMethodInvocation ? ((ReflectiveMethodInvocation)invocation).getProxy().getClass() : invocation.getThis().getClass();
            EntityGraphBean entityGraphCandidate = this.buildEntityGraphCandidate(providedEntityGraph, ResolvableType.forMethodReturnType((Method)invocation.getMethod(), implementationClass));
            if (entityGraphCandidate != null && !entityGraphCandidate.isValid()) {
                if (entityGraphCandidate.isOptional()) {
                    LOG.trace("Cannot apply EntityGraph {}", (Object)entityGraphCandidate);
                    entityGraphCandidate = null;
                } else {
                    throw new InapplicableEntityGraphException("Cannot apply EntityGraph " + entityGraphCandidate + " to the the current query");
                }
            }
            EntityGraphBean oldEntityGraphCandidate = this.currentEntityGraph.get();
            boolean bl = newEntityGraphCandidatePreValidated = entityGraphCandidate != null && (oldEntityGraphCandidate == null || !oldEntityGraphCandidate.isPrimary());
            if (newEntityGraphCandidatePreValidated) {
                this.currentEntityGraph.set(entityGraphCandidate);
            }
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                if (newEntityGraphCandidatePreValidated) {
                    this.currentEntityGraph.set(oldEntityGraphCandidate);
                }
            }
        }

        private EntityGraphBean buildEntityGraphCandidate(com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph providedEntityGraph, ResolvableType returnType) {
            EntityGraph.EntityGraphType type;
            boolean isPrimary = true;
            if (EntityGraphs.isEmpty(providedEntityGraph)) {
                providedEntityGraph = this.defaultEntityGraph;
                isPrimary = false;
            }
            if (providedEntityGraph == null) {
                return null;
            }
            EntityGraphType entityGraphType = Objects.requireNonNull(providedEntityGraph.getEntityGraphType());
            switch (entityGraphType) {
                case FETCH: {
                    type = EntityGraph.EntityGraphType.FETCH;
                    break;
                }
                case LOAD: {
                    type = EntityGraph.EntityGraphType.LOAD;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected entity graph type '" + (Object)((Object)entityGraphType) + "'");
                }
            }
            List<String> attributePaths = providedEntityGraph.getEntityGraphAttributePaths();
            JpaEntityGraph jpaEntityGraph = new JpaEntityGraph(StringUtils.hasText((String)providedEntityGraph.getEntityGraphName()) ? providedEntityGraph.getEntityGraphName() : this.domainClass.getName() + "-_-_-_-_-_-", type, attributePaths != null ? attributePaths.toArray(new String[0]) : null);
            return new EntityGraphBean(jpaEntityGraph, this.domainClass, returnType, providedEntityGraph.isOptional(), isPrimary);
        }
    }
}

