/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraphQueryHint;
import com.cosium.spring.data.jpa.entity.graph.repository.support.CountQueryDetector;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphQueryHintCandidate;
import com.cosium.spring.data.jpa.entity.graph.repository.support.QueryHintsUtils;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;

class RepositoryQueryEntityGraphInjector
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryQueryEntityGraphInjector.class);
    private static final List<String> EXECUTE_QUERY_METHODS = Arrays.asList("getResultList", "getSingleResult", "getResultStream", "scroll");
    private static final String UNWRAP_METHOD = "unwrap";
    private final EntityGraphQueryHintCandidate entityGraphCandidate;

    private RepositoryQueryEntityGraphInjector(EntityGraphQueryHintCandidate entityGraphCandidate) {
        this.entityGraphCandidate = Objects.requireNonNull(entityGraphCandidate);
    }

    static Query proxy(Query query, EntityGraphQueryHintCandidate entityGraphCandidate) {
        ProxyFactory proxyFactory = new ProxyFactory((Object)query);
        proxyFactory.addAdvice((Advice)new RepositoryQueryEntityGraphInjector(entityGraphCandidate));
        return (Query)proxyFactory.getProxy();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String invokedMethodName = invocation.getMethod().getName();
        Object[] invokedMethodArguments = invocation.getArguments();
        if (UNWRAP_METHOD.equals(invocation.getMethod().getName()) && invokedMethodArguments.length == 1 && invokedMethodArguments[0] == null) {
            return invocation.getThis();
        }
        if (EXECUTE_QUERY_METHODS.contains(invokedMethodName)) {
            this.addEntityGraphToQuery((Query)invocation.getThis());
        }
        return invocation.proceed();
    }

    private void addEntityGraphToQuery(Query query) {
        if (CountQueryDetector.isCountQuery()) {
            LOG.trace("CountQuery detected.");
            return;
        }
        if (!this.entityGraphCandidate.primary() && QueryHintsUtils.containsEntityGraph(query.getHints())) {
            LOG.trace("The query hints passed with the find method already hold an entity graph. Overriding aborted because the candidate EntityGraph is optional.");
            return;
        }
        QueryHintsUtils.removeEntityGraphs(query.getHints());
        EntityGraphQueryHint entityGraphQueryHint = this.entityGraphCandidate.queryHint();
        query.setHint(entityGraphQueryHint.type().key(), entityGraphQueryHint.entityGraph());
    }
}

