/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.synapse_junit_extension;

import com.cosium.synapse_junit_extension.JsonBody;
import com.cosium.synapse_junit_extension.ObjectMappers;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

class JsonHandlers {
    public static final JsonHandlers INSTANCE = new JsonHandlers();
    private final ObjectMapper objectMapper = ObjectMappers.forJson();

    private JsonHandlers() {
    }

    public HttpRequest.BodyPublisher publisher(Object value) {
        try {
            String json = this.objectMapper.writeValueAsString(value);
            return HttpRequest.BodyPublishers.ofString(json);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public <T> HttpResponse.BodyHandler<JsonBody<T>> handler(Class<T> type) {
        return responseInfo -> this.createBodySubscriber(responseInfo, type);
    }

    private <T> HttpResponse.BodySubscriber<JsonBody<T>> createBodySubscriber(HttpResponse.ResponseInfo responseInfo, Class<T> type) {
        int statusCode = responseInfo.statusCode();
        if (statusCode != 200) {
            return HttpResponse.BodySubscribers.replacing(new JsonBody<Object>(statusCode, null));
        }
        return HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofInputStream(), inputStream -> {
            try {
                return new JsonBody<Object>(statusCode, this.objectMapper.readValue(inputStream, type));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

