/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.synapse_junit_extension;

import com.cosium.synapse_junit_extension.CloseableResource;
import com.cosium.synapse_junit_extension.HomeServerConfig;
import com.cosium.synapse_junit_extension.ObjectMappers;
import com.cosium.synapse_junit_extension.SynapseClient;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.VolumeOptions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ResourceReaper;

public class Synapse {
    private static final Logger LOGGER = LoggerFactory.getLogger(Synapse.class);
    private static final int HTTP_PORT = 8008;
    private static final String ADMIN_USERNAME = "admin_user";
    private static final String ADMIN_PASSWORD = "admin_secret";
    private static final Map<String, String> VOLUME_LABELS = Map.of(DockerClientFactory.TESTCONTAINERS_SESSION_ID_LABEL, DockerClientFactory.SESSION_ID);
    private final GenericContainer<?> container;
    private final String hostname;
    private final int port;
    private final String url;
    private final String networkAlias;

    private Synapse(Starter starter) {
        String volumeName = "synapse-junit-extension.synapse." + UUID.randomUUID();
        this.networkAlias = starter.networkAlias;
        String dockerImageName = starter.dockerImageName;
        try (GenericContainer transientContainer = Synapse.createContainer(dockerImageName, volumeName, this.networkAlias).withCommand("generate").waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*A config file has been generated.*"));){
            transientContainer.start();
        }
        this.container = Synapse.createContainer(dockerImageName, volumeName, this.networkAlias).withExposedPorts(new Integer[]{8008}).withNetwork(starter.network).withNetworkAliases(new String[]{this.networkAlias});
        this.container.start();
        HomeServerConfig serverConfig = (HomeServerConfig)this.container.copyFileFromContainer("/data/homeserver.yaml", inputStream -> (HomeServerConfig)ObjectMappers.forYaml().readValue(inputStream, HomeServerConfig.class));
        this.hostname = "localhost";
        this.port = this.container.getMappedPort(8008);
        this.url = String.format("http://%s:%s", this.hostname, this.port);
        new SynapseClient(this.url).createUser(serverConfig.registrationSharedSecret(), ADMIN_USERNAME, ADMIN_PASSWORD, true);
    }

    public static Starter starter() {
        return new Starter();
    }

    @Deprecated(forRemoval=true)
    public static CloseableResource<Synapse> start(String dockerImageName, Network network) {
        return Synapse.starter().dockerImageName(dockerImageName).network(network).start();
    }

    private static GenericContainer<?> createContainer(String dockerImageName, String volumeName, String networkAlias) {
        ResourceReaper.instance().registerLabelsFilterForCleanup(VOLUME_LABELS);
        return new GenericContainer(DockerImageName.parse((String)dockerImageName)).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).withStartupTimeout(Duration.ofMinutes(30L)).withCreateContainerCmdModifier(command -> {
            HostConfig hostConfig = command.getHostConfig();
            Objects.requireNonNull(hostConfig);
            hostConfig.withMounts(List.of(new Mount().withVolumeOptions(new VolumeOptions().withLabels(VOLUME_LABELS)).withSource(volumeName).withTarget("/data")));
        }).withEnv("SYNAPSE_SERVER_NAME", networkAlias).withEnv("SYNAPSE_REPORT_STATS", "no");
    }

    public boolean https() {
        return false;
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public String url() {
        return this.url;
    }

    public boolean dockerHttps() {
        return false;
    }

    public String dockerHostname() {
        return this.networkAlias;
    }

    public int dockerPort() {
        return 8008;
    }

    public String dockerUrl() {
        return "http://" + this.dockerHostname() + ":" + this.dockerPort();
    }

    public String adminUsername() {
        return ADMIN_USERNAME;
    }

    public String adminPassword() {
        return ADMIN_PASSWORD;
    }

    private void stop() {
        this.container.stop();
    }

    public static class Starter {
        private String dockerImageName = "matrixdotorg/synapse:v1.86.0";
        private Network network;
        private String networkAlias = "synapse";

        private Starter() {
        }

        public Starter dockerImageName(String dockerImageName) {
            this.dockerImageName = Objects.requireNonNull(dockerImageName);
            return this;
        }

        public Starter network(Network network) {
            this.network = network;
            return this;
        }

        public Starter networkAlias(String networkAlias) {
            this.networkAlias = Objects.requireNonNull(networkAlias);
            return this;
        }

        public CloseableResource<Synapse> start() {
            final Synapse server = new Synapse(this);
            return new CloseableResource<Synapse>(){

                @Override
                public Synapse resource() {
                    return server;
                }

                @Override
                public void close() {
                    server.stop();
                }
            };
        }
    }
}

