/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.synapse_junit_extension;

import com.cosium.synapse_junit_extension.CloseableResource;
import com.cosium.synapse_junit_extension.DockerNetworkProvider;
import com.cosium.synapse_junit_extension.EnableSynapse;
import com.cosium.synapse_junit_extension.JUnitCloseableResource;
import com.cosium.synapse_junit_extension.Synapse;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.testcontainers.containers.Network;

public class SynapseExtension
implements BeforeAllCallback,
ParameterResolver {
    public static final String DEFAULT_DOCKER_IMAGE_NAME = "matrixdotorg/synapse:v1.86.0";
    public static final String DEFAULT_NETWORK_ALIAS = "synapse";

    public void beforeAll(ExtensionContext context) {
        new Environment(context).addNewSynapseIfNeed();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Synapse.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return new Environment(extensionContext).getSynapse();
    }

    private static class Environment {
        private final ExtensionContext.Store store;
        private final EnableSynapseMetadata metadata;

        public Environment(ExtensionContext context) {
            this.store = context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
            this.metadata = new EnableSynapseMetadata(context);
        }

        public void addNewSynapseIfNeed() {
            if (this.store.get((Object)this.metadata) != null) {
                return;
            }
            Synapse.Starter starter = Synapse.starter().dockerImageName(this.metadata.dockerImageName).networkAlias(this.metadata.networkAlias);
            this.metadata.networkSupplier.get().ifPresent(starter::network);
            CloseableResource<Synapse> server = starter.start();
            this.store.put(new Object(), (Object)new JUnitCloseableResource(server::close));
            this.store.put((Object)this.metadata, (Object)server.resource());
        }

        public Synapse getSynapse() {
            return (Synapse)this.store.get((Object)this.metadata, Synapse.class);
        }
    }

    private static class EnableSynapseMetadata {
        private final String dockerImageName;
        private final Class<? extends DockerNetworkProvider> dockerNetworkProviderClass;
        private final Supplier<Optional<Network>> networkSupplier;
        private final String networkAlias;

        EnableSynapseMetadata(ExtensionContext context) {
            Optional<Object> enableSynapse = context.getTestClass().flatMap(testClass -> AnnotationSupport.findAnnotation((AnnotatedElement)testClass, EnableSynapse.class));
            this.dockerImageName = enableSynapse.map(EnableSynapse::value).orElse(SynapseExtension.DEFAULT_DOCKER_IMAGE_NAME);
            this.dockerNetworkProviderClass = enableSynapse.map(EnableSynapse::dockerNetworkProvider).orElse(null);
            this.networkSupplier = () -> Optional.ofNullable(this.dockerNetworkProviderClass).map(x$0 -> (DockerNetworkProvider)ReflectionSupport.newInstance((Class)x$0, (Object[])new Object[0])).flatMap(provider -> provider.get(context));
            this.networkAlias = enableSynapse.map(EnableSynapse::dockerNetworkAlias).orElse(SynapseExtension.DEFAULT_NETWORK_ALIAS);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnableSynapseMetadata that = (EnableSynapseMetadata)o;
            return Objects.equals(this.dockerImageName, that.dockerImageName) && Objects.equals(this.dockerNetworkProviderClass, that.dockerNetworkProviderClass);
        }

        public int hashCode() {
            return Objects.hash(this.dockerImageName, this.dockerNetworkProviderClass);
        }
    }
}

