/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 常量接口
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.constant;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 常量接口
 */
public interface Constants {
	public static final String PAGE = "page";
	public static final String LIMIT = "limit";
	public static final String DATA = "data";
	
	public static final String CONTEXT_PATH = "ctx";
	
	/**
	 * 数字0
	 */
	public static final String NUM_ZERO = "0";
	
	/**
	 * 当前系统运行平台的文件路径分割符
	 */
	public static final String PATH_SEPARATOR = "/";
	
	/**
	 * 一个空字符串
	 */
	public static final String BLANK = "";

	public static final String AMPERSAND        = "&";
	public static final String AND              = "and";
	public static final String AT               = "@";
	public static final String ASTERISK         = "*";
	public static final String STAR             = ASTERISK;
	public static final String BACK_SLASH       = "\\";
	public static final String COLON            = ":";
	public static final String COMMA            = ",";
	public static final String DASH             = "-";
	public static final String DOLLAR           = "$";
	public static final String DOT              = ".";
	public static final String DOTDOT           = "..";
	public static final String DOT_CLASS        = ".class";
	public static final String DOT_JAVA         = ".java";
	public static final String EMPTY            = "";
	public static final String EQUALS           = "=";
	public static final String FALSE            = "false";
	public static final String SLASH            = "/";
	public static final String HASH             = "#";
	public static final String HAT              = "^";
	public static final String LEFT_BRACE       = "{";
	public static final String LEFT_BRACKET     = "(";
	public static final String LEFT_CHEV        = "<";
	public static final String NEWLINE          = "\n";
	public static final String N                = "n";
	public static final String NO               = "no";
	public static final String NULL             = "null";
	public static final String OFF              = "off";
	public static final String ON               = "on";
	public static final String PERCENT          = "%";
	public static final String PIPE             = "|";
	public static final String PLUS             = "+";
	public static final String QUESTION_MARK    = "?";
	public static final String EXCLAMATION_MARK = "!";
	public static final String QUOTE            = "\"";
	public static final String RETURN           = "\r";
	public static final String TAB              = "\t";
	public static final String RIGHT_BRACE      = "}";
	public static final String RIGHT_BRACKET    = ")";
	public static final String RIGHT_CHEV       = ">";
	public static final String SEMICOLON        = ";";
	public static final String SINGLE_QUOTE     = "'";
	public static final String SPACE            = " ";
	public static final String LEFT_SQ_BRACKET  = "[";
	public static final String RIGHT_SQ_BRACKET = "]";
	public static final String TRUE             = "true";
	public static final String UNDERSCORE       = "_";
	public static final String UTF_8            = "UTF-8";
	public static final String ISO_8859_1       = "ISO-8859-1";
	public static final String Y                = "y";
	public static final String YES              = "yes";
	public static final String ONE 				= "1";
	public static final String ZERO				= "0";
	public static final String DOLLAR_LEFT_BRACE= "${";

	// ---------------------------------------------------------------- array

	public static final String[] EMPTY_ARRAY = new String[0];
}
