/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月15日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.constant.code;

import java.text.MessageFormat;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 系统异常代码
 */
public enum EECode {
	/**
	 * 系统异常
	 */
	E00000("00000","系统异常。"),
	
	E00001("00001","文件不存在。"),
	E00002("00002","目录不存在。"),
	E00003("00003",""),
	E00004("00004",""),
	E00005("00005",""),
	E00006("00006",""),
	E00007("00007",""),
	E00008("00008",""),
	E00009("00009",""),
	E00010("00010",""),
	E00011("00011",""),
	E00012("00012",""),
	E00013("00013",""),
	E00014("00014",""),
	E00015("00015",""),
	E00016("00016",""),
	E00017("00017",""),
	E00018("00018",""),
	E00019("00019",""),
	E00020("00020",""),

	/**
	 * 未知异常
	 */
	E99999("99999"," 未知异常。"),
	;
	
	private String code;
	private String message;
	private Object[] parameters;
	
	private EECode(String code,String message) {
		this.code = code;
		this.message = message;
	}
	
	public String code() {
		return this.code;
	}
	
	public String message() {
		if (parameters != null && parameters.length > 0) {
			return MessageFormat.format(this.message, parameters);
		} else {
			return this.message;
		}
	}
	
	@Override
	public String toString() {
		return message;
	}
	
	public static EECode get(String code) {
		for (EECode s : EECode.values()) {
            if (s.code()==code) {
                return s;
            }
        }
		return null;
	}

	public Object[] getParameters() {
		return parameters;
	}

	public void setParameters(Object[] parameters) {
		this.parameters = parameters;
	}
}
