/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月15日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.context;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 上下文缓存
 */
public class Context implements IContext {
	private static ThreadLocal<Context> ctx = new ThreadLocal<Context>();
	
	private Map<String, Object> objects = Maps.newConcurrentMap();
	
	public static Context getInstance(){
		if (ctx.get() == null) {
			ctx.set(new Context());
	    }
		return (Context)ctx.get();
	}

	/* (non-Javadoc)
	 * @see com.cottsoft.framework.context.IContext#getValue(java.lang.String)
	 */
	@Override
	public Object getValue(String key) {
		return this.objects.get(key);
	}

	/* (non-Javadoc)
	 * @see com.cottsoft.framework.context.IContext#setValue(java.lang.String, java.lang.String)
	 */
	@Override
	public void setValue(String key, String value) {
		this.objects.put(key, value);
	}

	/* (non-Javadoc)
	 * @see com.cottsoft.framework.context.IContext#clear()
	 */
	@Override
	public void clear() {
		ctx.set(null);
	}

}
