/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * Spring ApplicationContext
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月15日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.context;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * Spring ApplicationContext
 */
public class SpringApplicationContext implements ApplicationContextAware {
	//声明一个静态变量保存
	private static ApplicationContext context;
		
	/* (non-Javadoc)
	 * @see org.springframework.context.ApplicationContextAware#setApplicationContext(org.springframework.context.ApplicationContext)
	 */
	@SuppressWarnings("static-access")
	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.context = applicationContext;
	}

	public static ApplicationContext getContext(){
		  return context;
	}

	public static Object getBean(String beanName){
		  return context.getBean(beanName);
	}

}
