/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 框架层异常
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月15日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.exception;

import com.cottsoft.framework.constant.code.EECode;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 框架层异常
 */
public class FrameworkException extends Exception {
	private static final long serialVersionUID = -5237157345741294276L;
	private EECode code;
	
	public FrameworkException() {
		super();
	}
	
	/**
	 * @param code
	 */
	public FrameworkException(EECode code) {
		super();
		this.code = code;
	}

	/**
	 * @param message
	 * @param cause
	 * @param enableSuppression
	 * @param writableStackTrace
	 */
	public FrameworkException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
		super(message, cause, enableSuppression, writableStackTrace);
	}

	/**
	 * @param message
	 * @param cause
	 * @param enableSuppression
	 * @param writableStackTrace
	 * @param code
	 */
	public FrameworkException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, EECode code) {
		super(message, cause, enableSuppression, writableStackTrace);
		this.code = code;
	}

	/**
	 * @param message
	 * @param cause
	 */
	public FrameworkException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 * @param cause
	 * @param code
	 */
	public FrameworkException(String message, Throwable cause, EECode code) {
		super(message, cause);
	}

	/**
	 * @param message
	 */
	public FrameworkException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param code
	 */
	public FrameworkException(String message, EECode code) {
		super(message);
	}

	/**
	 * @param cause
	 */
	public FrameworkException(Throwable cause) {
		super(cause);
	}

	/**
	 * @param cause
	 * @param code
	 */
	public FrameworkException(Throwable cause, EECode code) {
		super(cause);
	}
	
	/**
	 * @param value
	 */
	public FrameworkException(Object value) {
		this(value.toString());
	}

	/**
	 * @param value
	 * @param code
	 */
	public FrameworkException(Object value, EECode code) {
		this(value.toString(),code);
	}
	
	/**
	 * @param value
	 * @param cause
	 */
	public FrameworkException(Object value,Throwable cause) {
		this(value.toString(),cause);
	}

	/**
	 * @param value
	 * @param cause
	 * @param code
	 */
	public FrameworkException(Object value, Throwable cause,EECode code) {
		this(value.toString(),cause,code);
	}

	public EECode getCode() {
		return code;
	}

	public void setCode(EECode code) {
		this.code = code;
	}
	
}
