/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月15日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * Class工具
 */
public class ClassUtil {
	
	/**
	 * Description: <br>
	 * 
	 * @param childClass
	 * @param index
	 * @return Class
	 */
	public static Class<?> getGenricClass(Class<?> childClass, int index) {
		Type type = childClass.getGenericSuperclass();
		while (!(type instanceof Class)) {
			if ((type instanceof WildcardType)) {
				type = ((WildcardType) type).getUpperBounds()[0];
			} else if ((type instanceof TypeVariable)) {
				type = ((TypeVariable<?>) type).getBounds()[0];
			} else if ((type instanceof ParameterizedType)) {
				ParameterizedType ptype = (ParameterizedType) type;
				Type[] types = ptype.getActualTypeArguments();
				if ((types == null) || (types.length == 0)) {
					return Object.class;
				}
				type = ptype.getActualTypeArguments()[index];
			} else if ((type instanceof GenericArrayType)) {
				type = ((GenericArrayType) type).getGenericComponentType();
			}
		}
		return (Class<?>) type;
	}

	/**
	 * Description: <br>
	 * 获取当前方法
	 * @return String
	 */
	public static String getCurrentMethod() {
		StackTraceElement[] yste = Thread.currentThread().getStackTrace();
		if (yste.length < 2) {
			return null;
		}
		String str = "";
		for (int i = 0; i < yste.length; i++) {
			if (yste[i].getMethodName().equals("getCurrentMethod")) {
				Class<?> cC = null;
				try {
					cC = Class.forName(yste[(i + 1)].getClassName());
				} catch (ClassNotFoundException e) {
					e.printStackTrace();
				}
				Method[] ym = cC.getMethods();
				str = yste[(i + 1)].toString();
				str = str.substring(0, str.lastIndexOf('('));
				for (int j = 0; j < ym.length; j++) {
					if (str.endsWith(ym[j].getName())) {
						return ym[j].getName();
					}
				}
			}
		}
		return null;
	}

	/**
	 * Description: <br>
	 * 格式化对象，并将MAP中的VAL赋值给对应的属性
	 * @param cls
	 * @param map
	 * @param formatStr
	 */
	public static void formatMap(Class<?> cls, Map<String, Object> map, String formatStr) {
		Field[] fields = cls.getDeclaredFields();
		for (Field field : fields) {
			String name = field.getName();
			String type = field.getGenericType().toString();
			Object value = map.get(name);
			if ((type.equals("class java.util.Date")) && (value != null)) {
				SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
				try {
					Date date = null;
					if ((map.get(name) instanceof Double)) {
						Double dl = (Double) value;
						date = new Date(dl.longValue());
					} else if ((map.get(name) instanceof Long)) {
						date = new Date(((Long) value).longValue());
					} else if ((map.get(name) instanceof String)) {
						date = sdf.parse((String) value);
					}
					map.put(name, date);
				} catch (Exception e) {
					if ((map.get(name) instanceof String)) {
						try {
							Date date = new Date(Long.parseLong((String) value));
							map.put(name, date);
						} catch (Exception localException1) {
						}
					}
				}
			}
			formatNumber(type, name, value, map);
		}
	}

	/**
	 * Description: <br>
	 * 格式华数字
	 * @param type
	 * @param name
	 * @param value
	 * @param map
	 */
	public static void formatNumber(String type, String name, Object value, Map<String, Object> map) {
		if ((type.equals("class java.lang.Integer")) && (value != null)) {
			if ((value instanceof String)) {
				map.put(name, Integer.valueOf((String) value));
			}
		} else if ((type.equals("class java.lang.Double")) && (value != null)) {
			if ((value instanceof String)) {
				map.put(name, Double.valueOf(Double.parseDouble((String) value)));
			}
		} else if ((type.equals("class java.lang.Float")) && (value != null)) {
			if ((value instanceof String)) {
				map.put(name, Float.valueOf(Float.parseFloat((String) value)));
			}
		} else if ((type.equals("int")) && (value != null)) {
			if ((value instanceof String)) {
				map.put(name, Integer.valueOf((String) value));
			}
		} else if ((type.equals("double")) && (value != null)) {
			if ((value instanceof String)) {
				map.put(name, Double.valueOf(Double.parseDouble((String) value)));
			}
		} else if ((type.equals("float")) && (value != null) && ((value instanceof String))) {
			map.put(name, Float.valueOf(Float.parseFloat((String) value)));
		}
	}
}
