/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 日期工具类
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;

import org.joda.time.DateTime;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 日期工具类
 */
public class DateUtil {
	/**
	 * Description：<br> 
	 * 将日期转换为yyyy-MM-dd HH:mm:ss
	 * @param date
	 * @return String
	 */
	public static String format(Date date) {
		return format(date, "yyyy-MM-dd HH:mm:ss");
	}
	
	/**
	 * Description：<br> 
	 * 将日期转换为yyyy-MM-dd
	 * @param date
	 * @return String
	 */
	public static String formatYmd(Date date) {
		return format(date, "yyyy-MM-dd");
	}
	
	/**
	 * Description：<br> 
	 * 根据类型格式化
	 * @param date
	 * @param pattern
	 * @return String
	 */
	public static String format(Date date, String pattern) {
		if (date == null) {
			return "null";
		}
		if (pattern == null || pattern.equals("") || pattern.equals("null")) {
			pattern = "yyyy-MM-dd HH:mm:ss";
		}
		return new java.text.SimpleDateFormat(pattern).format(date);
	}
	
	/**
	 * Description: <br>
	 * 将格式为日期的字符串转换为Date
	 * @param date
	 * @return Date 
	 */
	public static Date format(String date) {
		return format(date, null);
	}
	
	/**
	 * Description: <br>
	 * 将格式为日期的字符串转换为Date
	 * @param date
	 * @param pattern
	 * @return Date
	 */
	public static Date format(String date, String pattern) {
		if (pattern == null || pattern.equals("") || pattern.equals("null")) {
			pattern = "yyyy-MM-dd HH:mm:ss";
		}
		if (date == null || date.equals("") || date.equals("null")) {
			pattern = "mm:ss";
		}
		Date d = null;
		try {
			d = new java.text.SimpleDateFormat(pattern).parse(date);
		} catch (ParseException pe) {
			pe.printStackTrace();
		}
		return d;
	}
	
	/**
	 * Description: <br>
	 * 获取当前时间
	 * @return Timestamp
	 */
	public static Timestamp getToday() {
		return Timestamp.valueOf(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
	}
	
	/**
	 * Description: <br>
	 * 获取当前时间
	 * @return Date
	 */
	public static Date getSystemDate(){
		return new Date();
	}
}
