/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 实体工具
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.lang.reflect.Field;
import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 实体工具
 */
public class EntityUtil {
	
	/**
	 * Description: <br>
	 * 将Bean转为Map
	 * @param entity
	 * @return Map<String, Object>
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 */
	public static Map<String, Object> getEntityMap(Object entity)
			throws IllegalArgumentException, IllegalAccessException {
		Map<String, Object> map = Maps.newHashMap();
		Field[] fields = entity.getClass().getDeclaredFields();
		for (Field field : fields) {
			field.setAccessible(true);
			Object val = field.get(entity);
			String name = field.getName();
			map.put(name, val);
		}
		return map;
	}

	/**
	 * Description: <br>
	 * 生成主键ID
	 * @param nameSpace
	 * @return String
	 */
	public static String generateId(String nameSpace) {
		StringBuffer sb = new StringBuffer();
		sb.append(Long.toHexString(Long.parseLong(new StringBuilder(String
				.valueOf(nameSpace.hashCode())).toString())));
		sb.append("!");
		sb.append(UuidUtil.getUUid());
		if (sb.length() > 48) {
			return sb.substring(0, 47);
		}else{
			return sb.toString();
		}
	}
}
