/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 文件操作工具类。
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月15日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 文件操作工具类。
 */
public class FileUtil {
	/**
	 * Description：<br> 
	 * 根据传进来的参数，创建目录
	 * @param path
	 */
	public static void createFolder(String path){
		File dirFile = new File(path);
		if (!(dirFile.exists()) && !(dirFile.isDirectory())) {
			dirFile.mkdirs();
		}
	}
	
	/**
	 * Description：<br> 
	 * 往文件中追加内容
	 * @param pathAndName
	 * @param content
	 */
	public synchronized static void appendFile(String pathAndName,String content){
		FileReader reader = null;
		FileWriter writer = null;		
		RandomAccessFile randomFile = null;		

		try {
			reader = new FileReader(pathAndName);			
			if (reader.read() == -1) {
				writer = new FileWriter(pathAndName);
				writer.write(content);
			} else {
				randomFile = new RandomAccessFile(pathAndName, "rw");
				long fileLength = randomFile.length();
				randomFile.seek(fileLength);
				randomFile.write(("\r\n" + content).getBytes());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				close(writer);
			} catch (IOException e) {
				e.printStackTrace();
			}finally{
				try {
					close(randomFile);
				} catch (IOException e) {
					e.printStackTrace();
				}finally{
					try {
						close(reader);
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}
	}
	
	/**
	 * Description：<br> 
	 * 读取本地一个文件，并将其字符数组中的每一个字节值转成一个INT类型的数组
	 * @param filePath
	 * @return integer []
	 */
	public static Integer[] readFileToByteValueArray(String filePath){
		Integer[] byteArray =null;
		try {
			if(filePath!=null){
				byteArray = readFileToByteValueArray(new File(filePath));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return byteArray;
	}
	
	/**
	 * Description：<br> 
	 * 读取本地一个文件，并将其字符数组中的每一个字节值转成一个INT类型的数组
	 * @param file
	 * @return Integer[]
	 */
	public static Integer[] readFileToByteValueArray(File file){
		FileInputStream fis = null;
		Integer[] byteArray =null;
		try {
			if(file.exists() && file.isFile()){
				fis = new FileInputStream(file);
				byteArray = readFileToByteValueArray(fis);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} finally{
			try {
				if(fis!=null){
					fis.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return byteArray;
	}
	
	/**
	 * Description：<br> 
	 * 将一个文件入流中的每一个字节值转成一个INT类型的数组
	 * @param fileInputStream
	 * @return Integer[]
	 */
	public static Integer[] readFileToByteValueArray(FileInputStream fileInputStream){
		Integer[] byteArray =null;
		try {
			if(fileInputStream!=null){
				int b;
				List<Integer> byteList = new ArrayList<Integer>();
				while ((b = fileInputStream.read()) != -1) {
					byteList.add(b);
				}
				byteArray = new Integer[byteList.size()];
				byteList.toArray(byteArray);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return byteArray;
	}
	
	/**
	 * Description：<br> 
	 * 判断文件或路径是否存在
	 * @param filePath
	 * @return boolean
	 */
	public static boolean isExist(String filePath) {
		boolean isExist = false;
		File file = new File(filePath);
		if (file.exists()) {
			isExist = true;
		}
		return isExist;
	}
	
	/**
	 * Description：<br> 
	 * 关闭InputStream
	 * @param in
	 * @throws IOException
	 */
	public static void close(InputStream in) throws IOException{
		if (in != null) {
			in.close();
		}
	}
	
	/**
	 * Description：<br> 
	 * 关闭OutputStream
	 * @param out
	 * @throws IOException
	 */
	public static void close(OutputStream out) throws IOException{
		if (out != null) {
			out.close();
		}
	}
	
	/**
	 * Description：<br> 
	 * 关闭Reader
	 * @param reader
	 * @throws IOException
	 */
	public static void close(Reader reader) throws IOException{
		if (reader != null) {
			reader.close();
		}
	}
	
	/**
	 * Description：<br> 
	 * 关闭Writer
	 * @param writer
	 * @throws IOException
	 */
	public static void close(Writer writer) throws IOException{
		if (writer != null) {
			writer.close();
		}
	}

	/**
	 * Description：<br> 
	 * 关闭RandomAccessFile
	 * @param randomFile
	 * @throws IOException
	 */
	public static void close(RandomAccessFile randomFile) throws IOException{
		if (randomFile != null) {
			randomFile.close();
		}
	}
}
