/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * FTP工具
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.io.File;
import java.io.FileInputStream;

import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

import com.cottsoft.framework.constant.Constants;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * FTP工具 
 */
public class FtpUtil {
	
	/**
	 * FTP根目录
	 */
	public static String ROOT = "/";

	// 私用静态类本身实例
	private static FtpUtil ftpUtil;

	/**
	 * Description：<br> 
	 * 私用无参构造方法，确保不会补new，也不提供其它的构造方法
	 * @author  Simon.Hoo
	 * @date    2014年7月14日
	 * @version v1.0.0
	 */
	private FtpUtil() {
	}

	/**
	 * Description：<br> 
	 * 基于线程同步的获取实例的方法
	 * @return FtpUtil
	 */
	public synchronized static FtpUtil getInstance() {
		if (ftpUtil == null) {
			ftpUtil = new FtpUtil();
		}
		return ftpUtil;
	}

	// Apache Common net包下的FTP Client
	private static FTPClient ftpClient;
	
	/**
	 * Description：<br> 
	 * FTP连接
	 * @param path 登录到FTP的根目录
	 * @param addr FTP地址
	 * @param port 端口
	 * @param username FTP用户
	 * @param password FTP用户密码
	 * @return boolean
	 */
	public boolean connect(String path,String addr,int port,String username,String password){    
		boolean result = false; 
		try{
			ftpClient = new FTPClient();    
			int reply;    
			ftpClient.connect(addr,port);    
			ftpClient.login(username,password);    
			ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);    
			reply = ftpClient.getReplyCode();    
			if (!FTPReply.isPositiveCompletion(reply)) {    
				ftpClient.disconnect();    
				return result;    
			}    
			ftpClient.changeWorkingDirectory(path);    
			result = true;
		}catch(Exception e){
			e.printStackTrace();
		}
		return result;    
	}
	
	/**
	 * Description: <br>
	 * 上传
	 * @param file
	 * @param ftpDir
	 */
	public void upload(File file,String ftpDir){
    	try{
    		//上传目录
	        if(file.isDirectory()){         
	        	ftpClient.makeDirectory(file.getName());              
	        	ftpClient.changeWorkingDirectory(file.getName());    
	            String[] files = file.list();           
	            for (int i = 0; i < files.length; i++) {    
	                File itemFile = new File(file.getPath() + Constants.PATH_SEPARATOR + files[i] );    
	                if(itemFile.isDirectory()){    
	                    upload(itemFile,null);    
	                    ftpClient.changeToParentDirectory();    
	                }else{
	                	//上传本地文件到FTP服务器
	                    File acFile = new File(file.getPath() + Constants.PATH_SEPARATOR + files[i]);    
	                    FileInputStream input = new FileInputStream(acFile);    
	                    ftpClient.storeFile(acFile.getName(), input);    
	                    input.close();                          
	                }               
	            }    
	        }else{//上传文件
	        	//在FTP上创建同样的目录
	        	if(!StringUtil.isEmpty(ftpDir)){
		        	String dirPath = ftpDir.replace(Constants.PATH_SEPARATOR, Constants.SPACE).replace("/", Constants.SPACE).replace("\\", Constants.SPACE);
	        		String[] tmp = dirPath.split(" +");
		        	for(String name:tmp){
		        		File dir = new File(name);  
		        		ftpClient.makeDirectory(dir.getName());              
			        	ftpClient.changeWorkingDirectory(dir.getName());    
		        	}
	        	}
	        	
	        	//上传本地文件到FTP服务器
	            File acFile = new File(file.getPath());         
	            if(acFile.exists()){
		            FileInputStream input = new FileInputStream(acFile);    
		            ftpClient.storeFile(acFile.getName(), input);    
		            input.close();
	            }
	        }  
    	}catch(Exception e){
    		e.printStackTrace();
    	}
    }  
}
