/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * GZIP压缩
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * GZIP压缩
 */
public class GZipUtil {
	/**
	 * Description：<br> 
	 * Gzip压缩 
	 * @param sourceStr
	 * @return String
	 */
	public static String compress(String sourceStr){
		String compressedStr = null;
		ByteArrayOutputStream out = null;
		GZIPOutputStream gzip = null;
		try{
			if(!StringUtil.isAllEmpty(sourceStr)){
				out = new ByteArrayOutputStream();   
				gzip = new GZIPOutputStream(out);   
				gzip.write(sourceStr.getBytes());    
				compressedStr = out.toString("ISO-8859-1");
			}else{
				compressedStr = sourceStr;
			}
		}catch(IOException e){
			e.printStackTrace();
		}finally{
			try {
				if(null != out){
					out.flush();
					out.close();
				}
				if(null != gzip){
					gzip.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return compressedStr;
	}
	
	/**
	 * Description：<br> 
	 * Gzip解压
	 * @param compressedStr
	 * @return String
	 */
	public static String decompression(String compressedStr){
		String decompressionStr = "";
		ByteArrayOutputStream out = null;
		ByteArrayInputStream in = null;
		GZIPInputStream gunzip = null;
		try{
			if(!StringUtil.isAllEmpty(compressedStr)){
				out = new ByteArrayOutputStream();   
				in = new ByteArrayInputStream(compressedStr.getBytes("ISO-8859-1"));   
				gunzip = new GZIPInputStream(in);   
				byte[] buffer = new byte[256];   
				int n;   
				while ((n = gunzip.read(buffer))>= 0) {   
				    out.write(buffer, 0, n);   
				}   
				// toString()使用平台默认编码，也可以显式的指定如toString(&quot;GBK&quot;)   
				decompressionStr = out.toString();  
			}else{
				decompressionStr = compressedStr;
			}
		}catch(IOException e){
			e.printStackTrace();
		}finally{
			try {
				if(null != out){
					out.flush();
					out.close();
				}
				if(null != in){
					in.close();
				}
				if(null != gunzip){
					gunzip.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return decompressionStr;
	}
}
