/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 图片I/O处理工具类
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import com.cottsoft.framework.constant.Constants;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 图片I/O处理工具类
 */
public class ImageUtil {
	public static String PNG = "PNG";
	public static String JPG = "JPG";
	public static String GIF = "GIF";
	public static String BMP = "BMP";
	
	/**
	 * Description：<br> 
	 * 将一个图片字节流转换成一个图片对象
	 * @param imageByteArray 图片字节流数组
	 * @return 图片对象
	 */
	public static BufferedImage convertToImage(byte[] imageByteArray){
		BufferedImage image = null;
		ByteArrayInputStream in = null;
		try {
			if(imageByteArray!=null && imageByteArray.length > 0){
				in = new ByteArrayInputStream(imageByteArray);
				image = ImageIO.read(in);
			}
		} catch (Exception e) {		
			e.printStackTrace();
		} finally{
			try {
				if(in!=null){
					in.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return image;
	}
	
	/**
	 * Description：<br> 
	 * 将图片对象输出到磁盘文件
	 * @param image 图片对象
	 * @param formatName 文件格式
	 * @param output 输出的文件对象
	 */
	public static void writeImageToFile(BufferedImage image,String formatName,File output){
		try{
			FileUtil.createFolder(output.getPath().replace(output.getName(), Constants.BLANK));	
			ImageIO.write(image, formatName, output);			
		}catch(Exception e){
			e.printStackTrace();
		}
	}
}
