/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * JVM工具类
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * JVM工具类
 */
public class JvmUtil {
	/**
	 * Java 虚拟机实现供应商
	 */
	private static final String vendor = getJavaVendor();

	/**
	 * Java 运行时环境规范版本
	 */
	private static final float javaVersion = getJavaVersion();

	/**
	 * Description：<br> 
	 * 判断录前JVM版本是否不低于1.4
	 * @return boolean
	 */
	public static boolean isNotLessThan14() {
		return (javaVersion >= 1.4F);
	}

	/**
	 * Description：<br> 
	 * 判断录前JVM版本是否不低于1.5
	 * @return boolean
	 */
	public static boolean isNotLessThan15() {
		return (javaVersion >= 1.5F);
	}

	/**
	 * Description：<br> 
	 * 判断录前JVM版本是否不低于1.6
	 * @return boolean
	 */
	public static boolean isNotLessThan16() {
		return (javaVersion >= 1.6F);
	}

	/**
	 * Description：<br> 
	 * 判断录前JVM版本是否不低于1.7
	 * @return boolean
	 */
	public static boolean isNotLessThan17() {
		return (javaVersion >= 1.7F);
	}

	/**
	 * Description：<br> 
	 * 判断录前JVM版本是否不低于1.8
	 * @return boolean
	 */
	public static boolean isNotLessThan18() {
		return (javaVersion >= 1.8F);
	}

	/**
	 * Description：<br> 
	 * 获取当前Java 虚拟机实现供应商
	 * @return String
	 */
	public static final String getJavaVendor() {
		return System.getProperty("java.vm.vendor");
	}

	/**
	 * Description：<br> 
	 * 获取Java 运行时环境规范版本
	 * @return float
	 */
	public static final float getJavaVersion() {
		try {
			return ((isAndroid()) ? 1.5F : Float.parseFloat(System
					.getProperty("java.specification.version")));
		} catch (NumberFormatException e) {
			e.printStackTrace();
		}
		return 1.3F;
	}

	private static boolean isAndroid() {
		return (vendor.indexOf("Android") != -1);
	}

	/**
	 * Description：<br> 
	 * 测试方法
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println(JvmUtil.isNotLessThan17());
		System.out.println(JvmUtil.getJavaVendor());
		System.out.println(JvmUtil.getJavaVersion());
	}
}
