/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * 对象工具
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * 对象工具
 */
public class ObjectUtil {
	
	/**
	 * Description：<br>
	 * 如前传入的对象t为null，则通过返映实例货传入的类型实例
	 * @param c
	 * @param t
	 * @return T
	 */
	public static <T> T getNotNullObject(Class<T> c, T t) {
		if (t == null) {
			try {
				t = c.newInstance();
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}
		return t;
	}

	/**
	 * Safely compares two objects just like <code>equals()</code> would, except
	 * it allows any of the 2 objects to be <code>null</code>.
	 *
	 * @return <code>true</code> if arguments are equal, otherwise
	 *         <code>false</code>
	 */
	public static boolean equals(Object obj1, Object obj2) {
		return (obj1 != null) ? (obj1.equals(obj2)) : (obj2 == null);
	}

	/**
	 * Compares two objects or two object arrays. Useful for
	 * {@link Object#equals(Object)}.
	 * 
	 * @see #equals(Object, Object)
	 */
	public static boolean equalsEx(Object obj1, Object obj2) {
		if (obj1 == null) {
			return (obj2 == null);
		}
		if (obj2 == null) {
			return false;
		}
		if (obj1.getClass().isArray()) {
			if (obj2.getClass().isArray() == false) {
				return false;
			}
			return Arrays.equals((Object[]) obj1, (Object[]) obj2);
		} else {
			return obj1.equals(obj2);
		}
	}

	/**
	 * Non-symmetric utility for comparing the types of two objects. Might be
	 * useful for {@link Object#equals(Object)} if <code>instanceof</code> is
	 * not used.
	 * 
	 * @param object
	 *            <code>equals()</code> argument
	 * @param thiz
	 *            current class that overrides <code>equals()</code>
	 */
	public static boolean equalsType(Object object, Object thiz) {
		return (object != null) && (object.getClass().equals(thiz.getClass()));
	}

	// ---------------------------------------------------------------- clone

	/**
	 * Clone an object by invoking it's <code>clone()</code> method, even if it
	 * is not overridden.
	 */
	public static Object clone(Object source) throws CloneNotSupportedException {
		if (source == null) {
			return null;
		}
		try {
			return ReflectUtil.invokeDeclared(source, "clone", new Class[] {},
					new Object[] {});
		} catch (Exception ex) {
			throw new CloneNotSupportedException(
					"Can't invoke clone() on object due to: " + ex.getMessage());
		}
	}


	// ---------------------------------------------------------------- misc

	/**
	 * Returns length of the object.
	 */
	@SuppressWarnings("rawtypes")
	public static int length(Object obj) {
		if (obj == null) {
			return 0;
		}
		if (obj instanceof String) {
			return ((String) obj).length();
		}
		if (obj instanceof Collection) {
			return ((Collection) obj).size();
		}
		if (obj instanceof Map) {
			return ((Map) obj).size();
		}

		int count;
		if (obj instanceof Iterator) {
			Iterator iter = (Iterator) obj;
			count = 0;
			while (iter.hasNext()) {
				count++;
				iter.next();
			}
			return count;
		}
		if (obj instanceof Enumeration) {
			Enumeration enumeration = (Enumeration) obj;
			count = 0;
			while (enumeration.hasMoreElements()) {
				count++;
				enumeration.nextElement();
			}
			return count;
		}
		if (obj.getClass().isArray() == true) {
			return Array.getLength(obj);
		}
		return -1;
	}

	/**
	 * Returns true if first argument contains provided element. s
	 */
	@SuppressWarnings({ "rawtypes"})
	public static boolean containsElement(Object obj, Object element) {
		if (obj == null) {
			return false;
		}
		if (obj instanceof String) {
			if (element == null) {
				return false;
			}
			return ((String) obj).indexOf(element.toString()) != -1;
		}
		if (obj instanceof Collection) {
			return ((Collection) obj).contains(element);
		}
		if (obj instanceof Map) {
			return ((Map) obj).values().contains(element);
		}

		if (obj instanceof Iterator) {
			Iterator iter = (Iterator) obj;
			while (iter.hasNext()) {
				Object o = iter.next();
				if (equals(o, element)) {
					return true;
				}
			}
			return false;
		}
		if (obj instanceof Enumeration) {
			Enumeration enumeration = (Enumeration) obj;
			while (enumeration.hasMoreElements()) {
				Object o = enumeration.nextElement();
				if (equals(o, element)) {
					return true;
				}
			}
			return false;
		}
		if (obj.getClass().isArray() == true) {
			int len = Array.getLength(obj);
			for (int i = 0; i < len; i++) {
				Object o = Array.get(obj, i);
				if (equals(o, element)) {
					return true;
				}
			}
		}
		return false;
	}
}
