/*
 **************************************************************************
 * 版权声明：
 * 本软件为木偶人(http://www.cottsoft.com)开发研制。未经本人正式书面同意，
 * 其他任何个人、团体不得将本软件使用、复制、修改或发布于商业产品中。 
 **************************************************************************
 * 程序描述:
 * Request util
 * 
 **************************************************************************
 * 修改历史:  
 * Date:       	    by:    		    Reason:  
 *           
 * 2016年11月16日    Simon.Hoo		Initial Version.
 *************************************************************************
 */
package com.cottsoft.framework.util;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Simon.Hoo
 * @version v1.0.0
 * @since JDK1.7
 * Request util
 */
public class RequestUtil {
	
	/**
	 * Description：<br> 
	 * 判断是否AJAX请求
	 * @param request
	 * @return boolean
	 */
	public static boolean isAjax(HttpServletRequest request){
	    boolean ajax = "XMLHttpRequest".toLowerCase().equalsIgnoreCase(request.getHeader("X-Requested-With"));
	    String ajaxFlag = request.getParameter("ajax") == null ? "false" : request.getParameter("ajax");
	    boolean isAjax = (ajax) || (ajaxFlag.equalsIgnoreCase("true"));
	    return isAjax;
	}
}
