/*
 * Decompiled with CFR 0.152.
 */
package com.cottsoft.weedfs.client;

import com.cottsoft.weedfs.client.EHttpMethod;
import com.cottsoft.weedfs.client.FileResult;
import com.cottsoft.weedfs.client.HttpUtil;
import com.cottsoft.weedfs.client.Location;
import com.cottsoft.weedfs.client.RequestResult;
import com.cottsoft.weedfs.client.WeedAssign;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class WeedfsClient {
    private String masterHost = "127.0.0.1";
    private int masterPort = 9333;
    private String assign = "dir/assign";

    public RequestResult cache(File file) {
        RequestResult result = null;
        Gson gson = new Gson();
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist");
        }
        result = new RequestResult();
        WeedAssign assignedInfo = null;
        BufferedReader in = null;
        try {
            String inputLine;
            StringBuffer host = new StringBuffer();
            host.append("http://");
            host.append(this.masterHost);
            host.append(":");
            host.append(this.masterPort);
            host.append("/");
            in = new BufferedReader(new InputStreamReader(HttpUtil.request(host.toString(), this.assign, EHttpMethod.GET)));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            assignedInfo = (WeedAssign)gson.fromJson(response.toString(), WeedAssign.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileBody fileBody = new FileBody(file, "text/plain");
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        StringBuffer uri = new StringBuffer();
        uri.append("http://");
        uri.append(assignedInfo.getPublicUrl());
        uri.append("/");
        uri.append(assignedInfo.getFid());
        HttpPost post = new HttpPost(uri.toString());
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        entity.addPart("fileBody", (ContentBody)fileBody);
        post.setEntity((HttpEntity)entity);
        try {
            String response = EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)post).getEntity(), (String)"UTF-8");
            client.getConnectionManager().shutdown();
            FileResult fileResult = (FileResult)gson.fromJson(response, FileResult.class);
            result.setFid(assignedInfo.getFid());
            result.setSize(fileResult.getSize());
            result.setStatus(true);
            result.setFileUrl(uri.toString());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public RequestResult cache(String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist");
        }
        return this.cache(file);
    }

    public RequestResult get(String fid) {
        RequestResult result = null;
        if (fid == null || fid.length() == 0) {
            throw new IllegalArgumentException("FID cannot be empty");
        }
        String volumnId = fid.split(",")[0];
        Location location = null;
        BufferedReader in = null;
        try {
            String inputLine;
            StringBuffer host = new StringBuffer();
            host.append("http://");
            host.append(this.masterHost);
            host.append(":");
            host.append(this.masterPort);
            host.append("/");
            StringBuffer requestURI = new StringBuffer();
            requestURI.append(this.assign);
            requestURI.append("?volumeId=");
            requestURI.append(volumnId);
            in = new BufferedReader(new InputStreamReader(HttpUtil.request(host.toString(), requestURI.toString(), EHttpMethod.GET)));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            Gson gson = new Gson();
            location = (Location)gson.fromJson(response.toString(), Location.class);
            StringBuffer fileUrl = new StringBuffer();
            fileUrl.append("http://");
            fileUrl.append(location.getPublicUrl());
            fileUrl.append("/");
            fileUrl.append(fid);
            result = new RequestResult();
            result.setFid(fid);
            result.setStatus(true);
            result.setFileUrl(fileUrl.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public InputStream getInputStream(String fid) {
        RequestResult result = this.get(fid);
        return HttpUtil.request(result.getFileUrl(), EHttpMethod.GET);
    }

    public RequestResult delete(String fid) {
        RequestResult result = null;
        try {
            RequestResult fileGetResult = this.get(fid);
            HttpUtil.request(fileGetResult.getFileUrl(), EHttpMethod.DELETE);
            result = new RequestResult();
            result.setFid(fid);
            result.setFileUrl(fileGetResult.getFileUrl());
            result.setSize(fileGetResult.getSize());
            result.setStatus(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return result;
    }

    public String getMasterHost() {
        return this.masterHost;
    }

    public void setMasterHost(String masterHost) {
        this.masterHost = masterHost;
    }

    public int getMasterPort() {
        return this.masterPort;
    }

    public void setMasterPort(int masterPort) {
        this.masterPort = masterPort;
    }

    public String getAssign() {
        return this.assign;
    }

    public void setAssign(String assign) {
        this.assign = assign;
    }
}

