/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.transactions.TransactionAttempt;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.deferred.TransactionSerializedContext;
import com.couchbase.transactions.log.TransactionLogger;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class TransactionContext {
    private final Duration startTimeClient;
    private final Duration deferredElapsed;
    private final List<TransactionAttempt> attempts = new ArrayList<TransactionAttempt>();
    public final TransactionLogger LOGGER;
    private final String transactionId;
    private final Optional<SpanWrapper> span = Optional.empty();
    private final PerTransactionConfig perConfig;
    private final EventBus eventBus;
    @Stability.Volatile
    private Optional<TransactionSerializedContext> serialized = Optional.empty();

    public TransactionContext(EventBus eventBus, String transactionId, Duration now, Duration deferredElapsed, TransactionConfig config, PerTransactionConfig perConfig) {
        Objects.requireNonNull(transactionId);
        Objects.requireNonNull(now);
        Objects.requireNonNull(deferredElapsed);
        Objects.requireNonNull(config);
        Objects.requireNonNull(perConfig);
        Objects.requireNonNull(eventBus);
        this.perConfig = perConfig;
        this.eventBus = eventBus;
        this.transactionId = transactionId;
        this.startTimeClient = now;
        this.deferredElapsed = deferredElapsed;
        this.LOGGER = new TransactionLogger(eventBus, transactionId, config.logDirectly(), config.logDirectlyLevel().orElse(Event.Severity.INFO));
    }

    public long timeSinceStartOfTransactionsMillis(long now) {
        long expiredNanos = now - this.startTimeClient.toNanos() + this.deferredElapsed.toNanos();
        return TimeUnit.NANOSECONDS.toMillis(expiredNanos);
    }

    public boolean hasExpiredClientSide(TransactionConfig config) {
        boolean isExpired;
        long now = System.nanoTime();
        long expiredMillis = this.timeSinceStartOfTransactionsMillis(now);
        boolean bl = isExpired = expiredMillis > config.transactionExpirationTime().toMillis();
        if (isExpired) {
            this.LOGGER.info("Has expired client side (now=%dns start=%dns deferredElapsed=%dns expired=%dmillis config=%dms)", now, this.startTimeClient.toNanos(), this.deferredElapsed.toNanos(), expiredMillis, config.transactionExpirationTime().toMillis());
        }
        return isExpired;
    }

    public void addAttempt(TransactionAttempt attempt) {
        this.attempts.add(attempt);
    }

    public int numAttempts() {
        return this.attempts.size();
    }

    public List<TransactionAttempt> attempts() {
        return new ArrayList<TransactionAttempt>(this.attempts);
    }

    public String transactionId() {
        return this.transactionId;
    }

    public Duration startTimeClient() {
        return this.startTimeClient;
    }

    public Optional<SpanWrapper> span() {
        return this.span;
    }

    public PerTransactionConfig perTransactionConfig() {
        return this.perConfig;
    }

    public Optional<TransactionSerializedContext> serialized() {
        return this.serialized;
    }

    public void serialized(TransactionSerializedContext serialized) {
        this.serialized = Optional.of(serialized);
    }
}

