/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.transactions.TransactionJsonDocumentStatus;
import com.couchbase.transactions.cleanup.ClusterData;
import com.couchbase.transactions.components.DocumentMetadata;
import com.couchbase.transactions.components.TransactionLinks;
import com.couchbase.transactions.forwards.ForwardCompatibility;
import com.couchbase.transactions.util.DebugUtil;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class TransactionGetResult {
    @Nullable
    private final TransactionLinks links;
    private final Optional<DocumentMetadata> documentMetadata;
    private TransactionJsonDocumentStatus status;
    private byte[] content;
    private long cas;
    private final String id;
    private final ReactiveCollection collection;
    private final Transcoder transcoder;
    private final Optional<JsonObject> txnMeta;
    private static final int IDX_ATR_ID = 0;
    private static final int IDX_TRANSACTION_ID = 1;
    private static final int IDX_ATTEMPT_ID = 2;
    private static final int IDX_STAGED_CONTENT = 3;
    private static final int IDX_ATR_BUCKET_NAME = 4;
    private static final int IDX_ATR_SCOPE_AND_COLLECTION_NAME = 5;
    private static final int IDX_RESTORE_FIELDS = 6;
    private static final int IDX_OP = 7;
    private static final int IDX_CRC32_OF_STAGING = 8;
    private static final int IDX_DOCUMENT_FIELDS = 9;
    private static final int IDX_ATR_SCOPE_NAME = 10;
    private static final int IDX_FORWARD_COMPATIBILITY = 11;
    private static final int IDX_BODY = 12;

    @Stability.Internal
    public TransactionGetResult(String id, @Nullable byte[] content, long cas, ReactiveCollection collection, @Nullable TransactionLinks links, TransactionJsonDocumentStatus status, Optional<DocumentMetadata> documentMetadata, Transcoder transcoder, Optional<JsonObject> txnMeta) {
        this.id = id;
        this.content = content;
        this.cas = cas;
        this.collection = collection;
        this.links = links;
        this.status = status;
        this.documentMetadata = documentMetadata;
        this.transcoder = transcoder;
        this.txnMeta = txnMeta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionGetResult{");
        sb.append("id=").append(DebugUtil.docId(this.collection, this.id));
        sb.append(",cas=").append(this.cas);
        sb.append(",status=").append((Object)this.status);
        sb.append(",bucket=").append(this.collection.bucketName());
        sb.append(",coll=").append(this.collection.name());
        sb.append(",links=").append(this.links);
        sb.append(",txnMeta=").append(this.txnMeta);
        sb.append('}');
        return sb.toString();
    }

    @Stability.Internal
    public Optional<DocumentMetadata> documentMetadata() {
        return this.documentMetadata;
    }

    @Nullable
    @Stability.Internal
    public TransactionLinks links() {
        return this.links;
    }

    @Stability.Internal
    Optional<JsonObject> txnMeta() {
        return this.txnMeta;
    }

    public String id() {
        return this.id;
    }

    public long cas() {
        return this.cas;
    }

    public JsonObject contentAsObject() {
        return this.contentAs(JsonObject.class);
    }

    public <T> T contentAs(Class<T> target) {
        return (T)this.transcoder.decode(target, this.content, CodecFlags.JSON_COMPAT_FLAGS);
    }

    @Stability.Uncommitted
    public <T> T contentAs(Class<T> target, JsonSerializer serializer) {
        return (T)serializer.deserialize(target, this.content);
    }

    @Stability.Uncommitted
    public byte[] contentAsBytes() {
        return this.content;
    }

    TransactionGetResult cas(long cas) {
        this.cas = cas;
        return this;
    }

    @Deprecated
    @Nullable
    public TransactionJsonDocumentStatus status() {
        return this.status;
    }

    @Stability.Internal
    void serialize(JsonObject out) {
        out.put("cas", this.cas);
        out.put("id", this.id);
        out.put("collection", this.collection.name());
        out.put("bucket", this.collection.bucketName());
        out.put("scope", this.collection.scopeName());
    }

    @Stability.Internal
    static TransactionGetResult createFrom(JsonObject obj, ClusterData cd) {
        TransactionGetResult out = new TransactionGetResult(obj.getString("id"), new byte[0], obj.getLong("cas"), cd.getBucketFromName(obj.getString("bucket")).scope(obj.getString("scope")).collection(obj.getString("collection")), null, TransactionJsonDocumentStatus.NORMAL, Optional.empty(), cd.cluster().environment().transcoder(), Optional.empty());
        return out;
    }

    @Stability.Internal
    public TransactionGetResult status(TransactionJsonDocumentStatus status) {
        this.status = status;
        return this;
    }

    @Stability.Internal
    static TransactionGetResult createFromInsert(ReactiveCollection collection, String id, byte[] content, String transactionId, String attemptId, String atrId, String atrBucketName, String atrScopeName, String atrCollectionName, long cas, Transcoder transcoder) {
        TransactionLinks links = new TransactionLinks(Optional.of(new String(content, CharsetUtil.UTF_8)), Optional.ofNullable(atrId), Optional.ofNullable(atrBucketName), Optional.ofNullable(atrScopeName), Optional.ofNullable(atrCollectionName), Optional.of(transactionId), Optional.of(attemptId), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of("insert"), true, Optional.empty(), Optional.empty());
        TransactionGetResult out = new TransactionGetResult(id, content, cas, collection, links, TransactionJsonDocumentStatus.NORMAL, Optional.empty(), transcoder, Optional.empty());
        return out;
    }

    @Stability.Internal
    public static TransactionGetResult createFrom(TransactionGetResult doc, byte[] content, TransactionJsonDocumentStatus status) {
        TransactionLinks links = new TransactionLinks(doc.links.stagedContent(), doc.links.atrId(), doc.links.atrBucketName(), doc.links.atrScopeName(), doc.links.atrCollectionName(), doc.links.stagedTransactionId(), doc.links.stagedAttemptId(), doc.links.casPreTxn(), doc.links.revidPreTxn(), doc.links.exptimePreTxn(), doc.links.op(), doc.links.isDeleted(), doc.links.crc32OfStaging(), doc.links.forwardCompatibility());
        TransactionGetResult out = new TransactionGetResult(doc.id, content, doc.cas, doc.collection, links, status, doc.documentMetadata, doc.transcoder, Optional.empty());
        return out;
    }

    @Stability.Internal
    public static TransactionGetResult createFrom(ReactiveCollection collection, String id, LookupInResult doc, TransactionJsonDocumentStatus status, Transcoder transcoder) {
        JsonObject restore;
        Optional<String> atrId = Optional.empty();
        Optional<String> transactionId = Optional.empty();
        Optional<String> attemptId = Optional.empty();
        Optional<String> stagedContent = Optional.empty();
        Optional<String> atrBucketName = Optional.empty();
        Optional<String> atrScopeName = Optional.empty();
        Optional<String> atrCollectionName = Optional.empty();
        Optional<String> crc32OfStaging = Optional.empty();
        Optional<ForwardCompatibility> forwardCompatibility = Optional.empty();
        Optional<String> casPreTxn = Optional.empty();
        Optional<String> revidPreTxn = Optional.empty();
        Optional<Long> exptimePreTxn = Optional.empty();
        Optional<String> casFromDocument = Optional.empty();
        Optional<String> revidFromDocument = Optional.empty();
        Optional<Long> exptimeFromDocument = Optional.empty();
        Optional<String> crc32FromDocument = Optional.empty();
        Optional<String> op = Optional.empty();
        if (doc.exists(0)) {
            atrId = Optional.of(doc.contentAs(0, String.class));
        }
        if (doc.exists(1)) {
            transactionId = Optional.of(doc.contentAs(1, String.class));
        }
        if (doc.exists(2)) {
            attemptId = Optional.of(doc.contentAs(2, String.class));
        }
        if (doc.exists(3)) {
            byte[] raw = (byte[])doc.contentAs(3, byte[].class);
            String str = new String(raw, CharsetUtil.UTF_8);
            stagedContent = Optional.of(str);
        }
        if (doc.exists(4)) {
            atrBucketName = Optional.of(doc.contentAs(4, String.class));
        }
        if (doc.exists(10)) {
            atrScopeName = Optional.of(doc.contentAs(10, String.class));
            if (doc.exists(5)) {
                atrCollectionName = Optional.of(doc.contentAs(5, String.class));
            }
        } else if (doc.exists(5)) {
            String name = (String)doc.contentAs(5, String.class);
            String[] splits = name.split("\\.");
            atrScopeName = Optional.of(splits[0]);
            atrCollectionName = Optional.of(splits[1]);
        }
        if (doc.exists(6)) {
            restore = (JsonObject)doc.contentAs(6, JsonObject.class);
            casPreTxn = Optional.of(restore.getString("CAS"));
            revidPreTxn = Optional.of(restore.getString("revid"));
            exptimePreTxn = Optional.of(restore.getLong("exptime"));
        }
        if (doc.exists(7)) {
            op = Optional.of(doc.contentAs(7, String.class));
        }
        if (doc.exists(8)) {
            crc32OfStaging = Optional.of(doc.contentAs(8, String.class));
        }
        if (doc.exists(9)) {
            restore = (JsonObject)doc.contentAs(9, JsonObject.class);
            casFromDocument = Optional.ofNullable(restore.getString("CAS"));
            revidFromDocument = Optional.ofNullable(restore.getString("revid"));
            exptimeFromDocument = Optional.ofNullable(restore.getLong("exptime"));
            crc32FromDocument = Optional.ofNullable(restore.getString("value_crc32c"));
        }
        if (doc.exists(11)) {
            JsonObject json = doc.contentAsObject(11);
            ForwardCompatibility fc = new ForwardCompatibility(json);
            forwardCompatibility = Optional.of(fc);
        }
        byte[] content = doc.exists(12) ? (byte[])doc.contentAs(12, byte[].class) : new byte[]{};
        TransactionLinks links = new TransactionLinks(stagedContent, atrId, atrBucketName, atrScopeName, atrCollectionName, transactionId, attemptId, casPreTxn, revidPreTxn, exptimePreTxn, op, doc.isDeleted(), crc32OfStaging, forwardCompatibility);
        DocumentMetadata md = new DocumentMetadata(casFromDocument, revidFromDocument, exptimeFromDocument, crc32FromDocument);
        TransactionGetResult out = new TransactionGetResult(id, content, doc.cas(), collection, links, status, Optional.of(md), transcoder, Optional.empty());
        return out;
    }

    public ReactiveCollection collection() {
        return this.collection;
    }
}

