/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.cleanup;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.DocRecord;
import com.couchbase.transactions.forwards.ForwardCompatibility;
import com.couchbase.transactions.support.AttemptStates;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class CleanupRequest
implements Delayed {
    private final String attemptId;
    private final String atrId;
    private final ReactiveCollection atrCollection;
    private final Duration startTime;
    private final AttemptStates state;
    private final List<DocRecord> stagedReplaces;
    private final List<DocRecord> stagedRemoves;
    private final List<DocRecord> stagedInserts;
    private final Optional<ForwardCompatibility> forwardCompatibility;
    private final long ageMillis;
    private final long createdAt;
    private final Optional<DurabilityLevel> durabilityLevel;

    public CleanupRequest(String attemptId, String atrId, ReactiveCollection atrCollection, AttemptStates state, List<DocRecord> stagedReplaces, List<DocRecord> stagedRemoves, List<DocRecord> stagedInserts, Duration delay, Optional<ForwardCompatibility> forwardCompatibility, long ageMillis, Optional<DurabilityLevel> durabilityLevel) {
        Objects.requireNonNull(attemptId);
        Objects.requireNonNull(atrId);
        Objects.requireNonNull(atrCollection);
        this.attemptId = attemptId;
        this.atrId = atrId;
        this.atrCollection = atrCollection;
        this.startTime = Duration.of(System.nanoTime(), ChronoUnit.NANOS).plus(delay);
        this.stagedReplaces = stagedReplaces;
        this.stagedRemoves = stagedRemoves;
        this.stagedInserts = stagedInserts;
        this.state = state;
        this.forwardCompatibility = forwardCompatibility;
        this.ageMillis = ageMillis;
        this.createdAt = System.nanoTime();
        this.durabilityLevel = durabilityLevel;
    }

    public static CleanupRequest fromAtrEntry(ReactiveCollection atrCollection, ATREntry atrEntry) {
        return new CleanupRequest(atrEntry.attemptId(), atrEntry.atrId(), atrCollection, atrEntry.state(), atrEntry.replacedIds().orElse(new ArrayList()), atrEntry.removedIds().orElse(new ArrayList()), atrEntry.insertedIds().orElse(new ArrayList()), Duration.ZERO, atrEntry.forwardCompatibility(), atrEntry.ageMsecs(), atrEntry.durabilityLevel());
    }

    public long createdAt() {
        return this.createdAt;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public String atrId() {
        return this.atrId;
    }

    public ReactiveCollection atrCollection() {
        return this.atrCollection;
    }

    public List<DocRecord> stagedReplaces() {
        return this.stagedReplaces;
    }

    public List<DocRecord> stagedRemoves() {
        return this.stagedRemoves;
    }

    public List<DocRecord> stagedInserts() {
        return this.stagedInserts;
    }

    public AttemptStates state() {
        return this.state;
    }

    public Optional<ForwardCompatibility> forwardCompatibility() {
        return this.forwardCompatibility;
    }

    public Optional<DurabilityLevel> durabilityLevel() {
        return this.durabilityLevel;
    }

    public long ageMillis() {
        return this.ageMillis;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        Duration diff = this.startTime.minus(Duration.of(System.nanoTime(), ChronoUnit.NANOS));
        return diff.toNanos();
    }

    @Override
    public int compareTo(Delayed o) {
        if (o instanceof CleanupRequest) {
            return Long.compare(this.startTime.toNanos(), ((CleanupRequest)o).startTime.toNanos());
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CleanupRequest(");
        sb.append("atrId=");
        sb.append(this.atrId);
        sb.append(",attemptId=");
        sb.append(this.attemptId);
        sb.append(",state=");
        sb.append((Object)this.state);
        sb.append(",inserts=");
        sb.append(this.stagedInserts);
        sb.append(",replaces=");
        sb.append(this.stagedReplaces);
        sb.append(",removes=");
        sb.append(this.stagedRemoves);
        sb.append(",ageMillis=");
        sb.append(this.ageMillis);
        sb.append(",fc=");
        sb.append(this.forwardCompatibility);
        sb.append(",durability=");
        sb.append(this.durabilityLevel);
        sb.append(")");
        return sb.toString();
    }
}

