/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.transactions.TransactionAttempt;
import com.couchbase.transactions.components.ATR;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.CasMode;
import com.couchbase.transactions.components.DocRecord;
import com.couchbase.transactions.components.DurabilityLevelUtil;
import com.couchbase.transactions.components.SerializationUtil;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.forwards.ForwardCompatibility;
import com.couchbase.transactions.support.AttemptStates;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ActiveTransactionRecord {
    private ActiveTransactionRecord() {
    }

    public static Optional<ATREntry> findEntryForTransaction(TransactionAttempt attempt, TransactionConfig config) {
        if (!attempt.atrCollection().isPresent() || !attempt.atrId().isPresent()) {
            throw new IllegalStateException();
        }
        return (Optional)ActiveTransactionRecord.findEntryForTransaction(attempt.atrCollection().get(), attempt.atrId().get(), attempt.attemptId(), config).block();
    }

    public static Mono<Optional<ATREntry>> findEntryForTransaction(ReactiveCollection atrCollection, String atrId, String attemptId, TransactionConfig config) {
        return atrCollection.lookupIn(atrId, Arrays.asList(LookupInSpec.get((String)("attempts." + attemptId)).xattr(), LookupInSpec.get((String)"$vbucket.HLC").xattr()), (LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().serializer((JsonSerializer)SerializationUtil.DEFAULT_JSON_SERIALIZER).clientContext(OptionsWrapperUtil.createClientContext("ATR::findEntryForTransaction"))).timeout(OptionsWrapperUtil.kvTimeoutNonMutating(config, atrCollection.core()))).map(d -> {
            if (!d.exists(0)) {
                return Optional.empty();
            }
            JsonObject hlc = (JsonObject)d.contentAs(1, JsonObject.class);
            ParsedHLC parsedHLC = new ParsedHLC(hlc);
            ATREntry entry = ActiveTransactionRecord.createFrom(atrCollection.bucketName(), atrId, d.contentAsObject(0), attemptId, parsedHLC.nowInNanos());
            return Optional.of(entry);
        });
    }

    public static ATREntry createFrom(String atrBucket, String atrId, JsonObject entry, String attemptId, long cas) {
        Objects.requireNonNull(entry);
        Objects.requireNonNull(attemptId);
        AttemptStates state = AttemptStates.valueOf(entry.getString("st"));
        Optional<ForwardCompatibility> fc = Optional.ofNullable(entry.getObject("fc")).map(json -> new ForwardCompatibility((JsonObject)json));
        Optional<DurabilityLevel> dl = Optional.ofNullable(entry.getString("d")).map(DurabilityLevelUtil::convertDurabilityLevel);
        return new ATREntry(atrBucket, atrId, attemptId, Optional.ofNullable(entry.getString("tid")), state, ActiveTransactionRecord.parseMutationCASField(entry.getString("tst")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsc")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsco")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsrs")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsrc")), Optional.ofNullable(entry.getInt("exp")), ActiveTransactionRecord.processDocumentIdArray(entry.getArray("ins")), ActiveTransactionRecord.processDocumentIdArray(entry.getArray("rep")), ActiveTransactionRecord.processDocumentIdArray(entry.getArray("rem")), cas, fc, dl);
    }

    public static Optional<List<DocRecord>> processDocumentIdArray(JsonArray array) {
        if (array == null) {
            return Optional.empty();
        }
        return Optional.of(array.toList().stream().map(v -> DocRecord.createFrom((HashMap)v)).collect(Collectors.toList()));
    }

    public static long parseMutationCAS(String in) {
        int offsetIndex = 2;
        long result = 0L;
        for (int octetIndex = 7; octetIndex >= 0; --octetIndex) {
            char char1 = in.charAt(offsetIndex + octetIndex * 2);
            char char2 = in.charAt(offsetIndex + octetIndex * 2 + 1);
            long octet1 = 0L;
            long octet2 = 0L;
            if (char1 >= 'a' && char1 <= 'f') {
                octet1 = char1 - 97 + 10;
            } else if (char1 >= 'A' && char1 <= 'F') {
                octet1 = char1 - 65 + 10;
            } else if (char1 >= '0' && char1 <= '9') {
                octet1 = char1 - 48;
            } else {
                throw new IllegalStateException("Could not parse CAS " + in);
            }
            if (char2 >= 'a' && char2 <= 'f') {
                octet2 = char2 - 97 + 10;
            } else if (char2 >= 'A' && char2 <= 'F') {
                octet2 = char2 - 65 + 10;
            } else if (char2 >= '0' && char2 <= '9') {
                octet2 = char2 - 48;
            } else {
                throw new IllegalStateException("Could not parse CAS " + in);
            }
            result |= octet1 << octetIndex * 8 + 4;
            result |= octet2 << octetIndex * 8;
        }
        return result / 1000000L;
    }

    public static Optional<Long> parseMutationCASField(String str) {
        if (str == null) {
            return Optional.empty();
        }
        return Optional.of(ActiveTransactionRecord.parseMutationCAS(str));
    }

    public static Mono<Optional<ATR>> getAtr(ReactiveCollection atrCollection, String atrId, Duration timeout, SpanWrapper pspan) {
        return atrCollection.lookupIn(atrId, Arrays.asList(LookupInSpec.get((String)"attempts").xattr(), LookupInSpec.get((String)"$vbucket.HLC").xattr()), (LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().serializer((JsonSerializer)SerializationUtil.DEFAULT_JSON_SERIALIZER).clientContext(OptionsWrapperUtil.createClientContext("ATR::getAtrWithUpToDateCas"))).timeout(timeout)).map(d -> {
            JsonObject attempts = (JsonObject)d.contentAs(0, JsonObject.class);
            JsonObject hlc = (JsonObject)d.contentAs(1, JsonObject.class);
            ParsedHLC parsedHLC = new ParsedHLC(hlc);
            return Optional.of(ActiveTransactionRecord.mapToAtr(atrCollection, atrId, d, attempts, parsedHLC.nowInNanos(), parsedHLC.mode()));
        }).onErrorResume(err -> {
            if (err instanceof DocumentNotFoundException) {
                return Mono.just(Optional.empty());
            }
            return Mono.error((Throwable)err);
        });
    }

    private static ATR mapToAtr(ReactiveCollection atrCollection, String atrId, LookupInResult doc, JsonObject attempts, long cas, CasMode casMode) {
        List<ATREntry> entries = attempts.getNames().stream().map(name -> {
            JsonObject jo = attempts.getObject(name);
            return ActiveTransactionRecord.createFrom(atrCollection.bucketName(), atrId, jo, name, cas);
        }).collect(Collectors.toList());
        ATR atr = new ATR(atrId, atrCollection, cas, entries, casMode);
        return atr;
    }

    @Stability.Internal
    public static class ParsedHLC {
        private final CasMode mode;
        private final long nowInNanos;

        public ParsedHLC(JsonObject hlc) {
            String nowStr = hlc.getString("now");
            String modeStr = hlc.getString("mode");
            if (modeStr != null && modeStr.length() > 0) {
                switch (modeStr.charAt(0)) {
                    case 'l': {
                        this.mode = CasMode.LOGICAL;
                        break;
                    }
                    case 'r': {
                        this.mode = CasMode.REAL;
                        break;
                    }
                    default: {
                        this.mode = CasMode.UNKNOWN;
                        break;
                    }
                }
            } else {
                this.mode = CasMode.UNKNOWN;
            }
            long nowSeconds = Long.parseLong(nowStr);
            this.nowInNanos = TimeUnit.SECONDS.toNanos(nowSeconds);
        }

        public CasMode mode() {
            return this.mode;
        }

        public long nowInNanos() {
            return this.nowInNanos;
        }
    }
}

