/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.transactions.forwards.ForwardCompatibility;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class TransactionLinks {
    private final Optional<String> atrId;
    private final Optional<String> atrBucketName;
    private final Optional<String> atrScopeName;
    private final Optional<String> atrCollectionName;
    private final Optional<String> stagedTransactionId;
    private final Optional<String> stagedAttemptId;
    private final Optional<String> stagedContent;
    private final Optional<String> crc32OfStaging;
    private final Optional<String> casPreTxn;
    private final Optional<String> revidPreTxn;
    private final Optional<Long> exptimePreTxn;
    private final Optional<String> op;
    private final Optional<ForwardCompatibility> forwardCompatibility;
    private final boolean isDeleted;

    public TransactionLinks(Optional<String> stagedContent, Optional<String> atrId, Optional<String> atrBucketName, Optional<String> atrScopeName, Optional<String> atrCollectionName, Optional<String> stagedTransactionId, Optional<String> stagedAttemptId, Optional<String> casPreTxn, Optional<String> revidPreTxn, Optional<Long> exptimePreTxn, Optional<String> op, boolean isDeleted, Optional<String> crc32OfStaging, Optional<ForwardCompatibility> forwardCompatibility) {
        Objects.requireNonNull(stagedContent);
        Objects.requireNonNull(atrId);
        Objects.requireNonNull(stagedTransactionId);
        Objects.requireNonNull(stagedAttemptId);
        Objects.requireNonNull(atrBucketName);
        Objects.requireNonNull(atrScopeName);
        Objects.requireNonNull(atrCollectionName);
        Objects.requireNonNull(op);
        Objects.requireNonNull(crc32OfStaging);
        Objects.requireNonNull(forwardCompatibility);
        this.stagedContent = stagedContent;
        this.atrId = atrId;
        this.stagedTransactionId = stagedTransactionId;
        this.stagedAttemptId = stagedAttemptId;
        this.atrBucketName = atrBucketName;
        this.atrScopeName = atrScopeName;
        this.atrCollectionName = atrCollectionName;
        this.casPreTxn = casPreTxn;
        this.revidPreTxn = revidPreTxn;
        this.exptimePreTxn = exptimePreTxn;
        this.op = op;
        this.isDeleted = isDeleted;
        this.crc32OfStaging = crc32OfStaging;
        this.forwardCompatibility = forwardCompatibility;
    }

    public boolean isDocumentInTransaction() {
        return this.atrId.isPresent();
    }

    public boolean isDocumentBeingRemoved() {
        return this.op.isPresent() && this.op.get().equals("remove");
    }

    public boolean hasStagedWrite() {
        return this.stagedAttemptId.isPresent();
    }

    public Optional<String> atrId() {
        return this.atrId;
    }

    public Optional<String> stagedTransactionId() {
        return this.stagedTransactionId;
    }

    public Optional<String> stagedAttemptId() {
        return this.stagedAttemptId;
    }

    @Stability.Internal
    public Optional<String> stagedContent() {
        return this.stagedContent;
    }

    public Optional<String> atrBucketName() {
        return this.atrBucketName;
    }

    public Optional<String> atrScopeName() {
        return this.atrScopeName;
    }

    public Optional<String> atrCollectionName() {
        return this.atrCollectionName;
    }

    public Optional<String> casPreTxn() {
        return this.casPreTxn;
    }

    public Optional<String> revidPreTxn() {
        return this.revidPreTxn;
    }

    public Optional<Long> exptimePreTxn() {
        return this.exptimePreTxn;
    }

    public Optional<String> op() {
        return this.op;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public Optional<String> crc32OfStaging() {
        return this.crc32OfStaging;
    }

    public Optional<ForwardCompatibility> forwardCompatibility() {
        return this.forwardCompatibility;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionLinks{");
        sb.append("atr=").append(this.atrId.orElse("none"));
        sb.append(",atrBkt=").append(this.atrBucketName.orElse("none"));
        sb.append(",atrColl=").append(this.atrCollectionName.orElse("none"));
        sb.append(",txnId=").append(this.stagedTransactionId.orElse("none"));
        sb.append(",attemptId=").append(this.stagedAttemptId.orElse("none"));
        sb.append(",crc32Staging=").append(this.crc32OfStaging.orElse("none"));
        sb.append(",isDeleted=").append(this.isDeleted);
        this.stagedContent.ifPresent(s -> sb.append(",content=").append(s.length()).append("chars"));
        sb.append(",op=").append(this.op.orElse("none"));
        sb.append(",fc=").append(this.forwardCompatibility.map(Object::toString).orElse("none"));
        sb.append(",restore={");
        sb.append(this.casPreTxn.orElse("none"));
        sb.append(',');
        sb.append(this.revidPreTxn.orElse("none"));
        sb.append(',');
        sb.append(this.exptimePreTxn.orElse(-1L));
        sb.append("}}");
        return sb.toString();
    }

    public JsonObject stagedContentAsJson() {
        if (!this.stagedContent.isPresent()) {
            throw new IllegalStateException();
        }
        return JsonObject.fromJson((String)this.stagedContent.get());
    }
}

