/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.PerTransactionQueryConfigBuilder;
import java.util.Optional;

public class PerTransactionConfigBuilder {
    private Optional<TransactionDurabilityLevel> durabilityLevel = Optional.empty();
    private Optional<PerTransactionQueryConfigBuilder> queryConfig = Optional.empty();

    public static PerTransactionConfigBuilder create() {
        return new PerTransactionConfigBuilder();
    }

    public PerTransactionConfig build() {
        PerTransactionConfig config = new PerTransactionConfig(this.durabilityLevel, this.queryConfig.flatMap(v -> v.scanConsistency()));
        return config;
    }

    private PerTransactionConfigBuilder() {
    }

    public PerTransactionConfigBuilder durabilityLevel(TransactionDurabilityLevel durabilityLevel) {
        this.durabilityLevel = Optional.of(durabilityLevel);
        return this;
    }

    @Stability.Volatile
    public PerTransactionConfigBuilder queryConfig(PerTransactionQueryConfigBuilder queryConfig) {
        this.queryConfig = Optional.of(queryConfig);
        return this;
    }
}

