/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.cleanup.CleanerFactory;
import com.couchbase.transactions.cleanup.ClientRecordFactory;
import com.couchbase.transactions.support.AttemptContextFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class TransactionConfig {
    private TransactionDurabilityLevel transactionDurabilityLevel;
    private DurabilityLevel durabilityLevel;
    private final Duration transactionExpirationTime;
    private final boolean runLostAttemptsCleanupThread;
    private final boolean runRegularAttemptsCleanupThread;
    private final Duration cleanupWindow;
    private final Optional<Event.Severity> logDirectly;
    private final boolean logOnFailure;
    private final Event.Severity logOnFailureLevel;
    private final Optional<Duration> keyValueTimeout;
    private final AttemptContextFactory attemptContextFactory;
    private final CleanerFactory cleanerFactory;
    private final ClientRecordFactory clientRecordFactory;
    private final Optional<Collection> persistentLoggingCollection;
    private final int numAtrs;
    private Optional<Collection> metadataCollection = Optional.empty();
    private Optional<QueryScanConsistency> scanConsistency = Optional.empty();

    TransactionConfig(TransactionDurabilityLevel transactionDurabilityLevel, Duration transactionExpirationTime, boolean runLostAttemptsCleanupThread, boolean runRegularAttemptsCleanupThread, Duration cleanupWindow, Optional<Event.Severity> logDirectly, boolean logOnFailure, Event.Severity logOnFailureLevel, Optional<Duration> keyValueTimeout, AttemptContextFactory attemptContextFactory, CleanerFactory cleanerFactory, ClientRecordFactory clientRecordFactory, Optional<Collection> persistentLoggingCollection, int numAtrs, Optional<Collection> metadataCollection, Optional<QueryScanConsistency> scanConsistency) {
        Objects.requireNonNull(transactionDurabilityLevel);
        Objects.requireNonNull(logDirectly);
        Objects.requireNonNull(logOnFailureLevel);
        Objects.requireNonNull(keyValueTimeout);
        Objects.requireNonNull(attemptContextFactory);
        Objects.requireNonNull(cleanerFactory);
        Objects.requireNonNull(clientRecordFactory);
        Objects.requireNonNull(metadataCollection);
        Objects.requireNonNull(scanConsistency);
        this.transactionDurabilityLevel = transactionDurabilityLevel;
        switch (transactionDurabilityLevel) {
            case MAJORITY: {
                this.durabilityLevel = DurabilityLevel.MAJORITY;
                break;
            }
            case PERSIST_TO_MAJORITY: {
                this.durabilityLevel = DurabilityLevel.PERSIST_TO_MAJORITY;
                break;
            }
            case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                this.durabilityLevel = DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
                break;
            }
            case NONE: {
                this.durabilityLevel = DurabilityLevel.NONE;
                break;
            }
            default: {
                this.durabilityLevel = DurabilityLevel.MAJORITY;
            }
        }
        this.transactionExpirationTime = transactionExpirationTime;
        this.runLostAttemptsCleanupThread = runLostAttemptsCleanupThread;
        this.runRegularAttemptsCleanupThread = runRegularAttemptsCleanupThread;
        this.cleanupWindow = cleanupWindow;
        this.logDirectly = logDirectly;
        this.logOnFailure = logOnFailure;
        this.logOnFailureLevel = logOnFailureLevel;
        this.keyValueTimeout = keyValueTimeout;
        this.attemptContextFactory = attemptContextFactory;
        this.cleanerFactory = cleanerFactory;
        this.clientRecordFactory = clientRecordFactory;
        this.persistentLoggingCollection = persistentLoggingCollection;
        this.numAtrs = numAtrs;
        this.metadataCollection = metadataCollection;
        this.scanConsistency = scanConsistency;
    }

    public boolean logDirectly() {
        return this.logDirectly.isPresent();
    }

    public Optional<Event.Severity> logDirectlyLevel() {
        return this.logDirectly;
    }

    public boolean runLostAttemptsCleanupThread() {
        return this.runLostAttemptsCleanupThread;
    }

    public boolean runRegularAttemptsCleanupThread() {
        return this.runRegularAttemptsCleanupThread;
    }

    public Duration cleanupWindow() {
        return this.cleanupWindow;
    }

    public Duration transactionExpirationTime() {
        return this.transactionExpirationTime;
    }

    public boolean logOnFailure() {
        return this.logOnFailure;
    }

    public Event.Severity logOnFailureLevel() {
        return this.logOnFailureLevel;
    }

    public Optional<Duration> keyValueTimeout() {
        return this.keyValueTimeout;
    }

    public TransactionDurabilityLevel transactionDurabilityLevel() {
        return this.transactionDurabilityLevel;
    }

    public DurabilityLevel durabilityLevel() {
        return this.durabilityLevel;
    }

    public AttemptContextFactory attemptContextFactory() {
        return this.attemptContextFactory;
    }

    public CleanerFactory cleanerFactory() {
        return this.cleanerFactory;
    }

    public ClientRecordFactory clientRecordFactory() {
        return this.clientRecordFactory;
    }

    public Optional<Collection> persistentLoggingCollection() {
        return this.persistentLoggingCollection;
    }

    public int numAtrs() {
        return this.numAtrs;
    }

    public Optional<Collection> metadataCollection() {
        return this.metadataCollection;
    }

    public Optional<QueryScanConsistency> scanConsistency() {
        return this.scanConsistency;
    }
}

