/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.java.Collection;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.cleanup.CleanerFactory;
import com.couchbase.transactions.cleanup.ClientRecordFactory;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.config.TransactionQueryConfigBuilder;
import com.couchbase.transactions.support.AttemptContextFactory;
import com.couchbase.transactions.support.DefaultAttemptContextFactory;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;

public class TransactionConfigBuilder {
    private TransactionDurabilityLevel level = TransactionDurabilityLevel.MAJORITY;
    private Optional<Duration> expirationTime = Optional.empty();
    private Optional<Boolean> cleanupLostAttempts = Optional.empty();
    private Optional<Boolean> cleanupClientAttempts = Optional.empty();
    private Optional<Event.Severity> logDirectly = Optional.empty();
    private Optional<Duration> cleanupWindow = Optional.empty();
    private Optional<Boolean> logOnFailure = Optional.empty();
    private Optional<Event.Severity> logOnFailureLevel = Optional.empty();
    private Optional<Duration> keyValueTimeout = Optional.empty();
    private Optional<AttemptContextFactory> attemptContextFactory = Optional.empty();
    private Optional<CleanerFactory> cleanerFactory = Optional.empty();
    private Optional<ClientRecordFactory> clientRecordFactory = Optional.empty();
    private Optional<Collection> persistentLoggingCollection = Optional.empty();
    private Optional<Integer> numAtrs = Optional.empty();
    private Optional<Collection> metadataCollection = Optional.empty();
    private Optional<TransactionQueryConfigBuilder> queryConfig = Optional.empty();
    private static final Duration TRANSACTION_EXPIRATION_TIME_MSECS_DEFAULT = Duration.of(15L, ChronoUnit.SECONDS);
    private static final boolean RUN_BACKGROUND_CLEANUP_THREAD = true;
    private static final Duration CLEANUP_WINDOW_SECS = Duration.of(60L, ChronoUnit.SECONDS);
    private static final boolean LOG_ON_FAILURE = false;
    private static final Event.Severity LOG_ON_FAILURE_LEVEL = Event.Severity.DEBUG;

    public static TransactionConfigBuilder create() {
        return new TransactionConfigBuilder();
    }

    public TransactionConfig build() {
        TransactionConfig config = new TransactionConfig(this.level, this.expirationTime.orElse(TRANSACTION_EXPIRATION_TIME_MSECS_DEFAULT), this.cleanupLostAttempts.orElse(true), this.cleanupClientAttempts.orElse(true), this.cleanupWindow.orElse(CLEANUP_WINDOW_SECS), this.logDirectly, this.logOnFailure.orElse(false), this.logOnFailureLevel.orElse(LOG_ON_FAILURE_LEVEL), this.keyValueTimeout, this.attemptContextFactory.orElse(new DefaultAttemptContextFactory()), this.cleanerFactory.orElse(new CleanerFactory()), this.clientRecordFactory.orElse(new ClientRecordFactory()), this.persistentLoggingCollection, this.numAtrs.orElse(1024), this.metadataCollection, this.queryConfig.flatMap(v -> v.scanConsistency()));
        return config;
    }

    private TransactionConfigBuilder() {
    }

    public TransactionConfigBuilder cleanupClientAttempts(boolean cleanupClientAttempts) {
        this.cleanupClientAttempts = Optional.of(cleanupClientAttempts);
        return this;
    }

    public TransactionConfigBuilder cleanupLostAttempts(boolean cleanupLostAttempts) {
        this.cleanupLostAttempts = Optional.of(cleanupLostAttempts);
        return this;
    }

    public TransactionConfigBuilder cleanupWindow(Duration cleanupWindow) {
        this.cleanupWindow = Optional.of(cleanupWindow);
        return this;
    }

    public TransactionConfigBuilder expirationTime(Duration expirationTime) {
        this.expirationTime = Optional.of(expirationTime);
        return this;
    }

    public TransactionConfigBuilder durabilityLevel(TransactionDurabilityLevel level) {
        this.level = level;
        return this;
    }

    public TransactionConfigBuilder logDirectly(Event.Severity logLevel) {
        this.logDirectly = Optional.of(logLevel);
        return this;
    }

    public TransactionConfigBuilder logOnFailure(boolean logOnFailure, Event.Severity logOnFailureLevel) {
        this.logOnFailure = Optional.of(logOnFailure);
        this.logOnFailureLevel = Optional.of(logOnFailureLevel);
        return this;
    }

    public TransactionConfigBuilder keyValueTimeout(Duration timeout) {
        this.keyValueTimeout = Optional.of(timeout);
        return this;
    }

    @Stability.Internal
    public TransactionConfigBuilder testFactories(AttemptContextFactory attemptContextFactory, CleanerFactory cleanerFactory, ClientRecordFactory clientRecordFactory) {
        this.attemptContextFactory = Optional.ofNullable(attemptContextFactory);
        this.cleanerFactory = Optional.ofNullable(cleanerFactory);
        this.clientRecordFactory = Optional.ofNullable(clientRecordFactory);
        return this;
    }

    @Stability.Volatile
    public TransactionConfigBuilder persistentLogging(Collection collection) {
        this.persistentLoggingCollection = Optional.ofNullable(collection);
        return this;
    }

    @Stability.Internal
    public TransactionConfigBuilder numATRs(int atrs) {
        if (atrs < 0 || atrs > 20480) {
            throw new IllegalArgumentException("Number of ATRs cannot exceed 20480");
        }
        this.numAtrs = Optional.of(atrs);
        return this;
    }

    @Stability.Volatile
    public TransactionConfigBuilder metadataCollection(Collection collection) {
        this.metadataCollection = Optional.ofNullable(collection);
        return this;
    }

    @Stability.Volatile
    public TransactionConfigBuilder queryConfig(TransactionQueryConfigBuilder queryConfig) {
        this.queryConfig = Optional.of(queryConfig);
        return this;
    }
}

